<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universe
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */


defined('MOODLE_INTERNAL') || die();

$page = new admin_settingpage('theme_universe_block10', get_string('settingsblock10', 'theme_universe'));

$name = 'theme_universe/displayblock10';
$title = get_string('turnon', 'theme_universe');
$description = get_string('displayblock10_desc', 'theme_universe');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title .
    '<span class="badge badge-sq badge-dark ml-2">Block #10</span>', $description, $default);
$page->add($setting);

$name = 'theme_universe/displayhrblock10';
$title = get_string('displayblockhr', 'theme_universe');
$description = get_string('displayblockhr_desc', 'theme_universe');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block10id';
$title = get_string('additionalid', 'theme_universe');
$description = get_string('additionalid_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block10introsubtitle';
$title = get_string('blockintrosubtitle', 'theme_universe');
$description = get_string('blockintrosubtitle_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block10class';
$title = get_string('additionalclass', 'theme_universe');
$description = get_string('additionalclass_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block10introtitle';
$title = get_string('blockintrotitle', 'theme_universe');
$description = get_string('blockintrotitle_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block10introcontent';
$title = get_string('blockintrocontent', 'theme_universe');
$description = get_string('blockintrocontent_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block10htmlcontent';
$title = get_string('blockhtmlcontent', 'theme_universe');
$description = get_string('blockhtmlcontent_desc', 'theme_universe');
$default = '<div class="row align-items-lg-center">
<div class="rui-img-rounded--lg col-sm-12 col-lg-6 mb-4 mb-lg-0">
<img src="https://assets.rosea.io/universe/demo/600x600.jpg" alt="" width="600" height="600" class="img-fluid">
</div>
<div class="col-sm-12 col-lg offset-lg-1">
<div class="pt-lg-4 pt-0">
<h2 class="mb-xl-4">Custom Work</h2>
<p class="pb-3 mb-3 mb-xl-4">Do you need theme customization? Help with some Moodle issues?
Or maybe you can design and build a theme from scratch?</p>
<div class="row row-cols-2 pb-2 pb-xl-0 mb-4 mb-xl-5">
<div class="col">
<div class="rui-rounded-icon my-3" style="color: #000; background: #feedba;">
<svg width="24px"
    height="24px"
    stroke-width="1.5"
    viewBox="0 0 24 24"
    fill="none" xmlns="http://www.w3.org/2000/svg" color="currentColor">
<path
    d="M16 16.472V20a2 2 0 01-2 2h-4a2 2 0 01-2-2v-3.528M8 7.528V4a2
    2 0 012-2h4a2 2 0 012 2v3.528" stroke="currentColor"
stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
<path d="M18 12a6 6 0 10-12 0 6 6 0 0012 0z"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"></path>
<path d="M14 12h-2v-2"
    stroke="currentColor"
    stroke-width="1.5"
    stroke-linecap="round"
    stroke-linejoin="round"></path>
</svg>
</div>
<h3 class="h5 mb-2">Customization, Design</h3>
<p>30$/hour</p>
</div>
<div class="col">
<div class="rui-rounded-icon my-3" style="color: #000; background: #bdc4f4;">
<svg width="32px"
    height="32px"
    stroke-width="1.5"
    viewBox="0 0 24 24"
    fill="none" xmlns="http://www.w3.org/2000/svg"
    color="currentColor">
    <path
        d="M11 13.6V21H3.6a.6.6 0 01-.6-.6V13h7.4a.6.6 0 01.6.6zM11 21h3M3
        13v-3M6 3H3.6a.6.6 0 00-.6.6V6M14 3h-4M21 10v4M18 3h2.4a.6.6 0
        01.6.6V6M18 21h2.4a.6.6 0 00.6-.6V18M11 10h3v3"
        stroke="#000000"
        stroke-width="1.5"
        stroke-linecap="round"
        stroke-linejoin="round"></path>
</svg>
</div>
<h3 class="h5 mb-2">Custom Moodle Theme</h3>
<p>The price starts from $6000.</p>
</div>
</div>
<a class="btn btn-primary" href="#">Buy universe today</a>
</div>
</div>
</div>';
$setting = new universe_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block10footercontent';
$title = get_string('blockfootercontent', 'theme_universe');
$description = get_string('blockfootercontent_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block10customcss';
$title = get_string('blockcustomcss', 'theme_universe');
$description = get_string('blockcustomcss_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$settings->add($page);
