<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universe
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */

defined('MOODLE_INTERNAL') || die();
global $PAGE, $OUTPUT;

// Variables - Settings.
$block18introsubtitle = format_text(theme_universe_get_setting('block18introsubtitle'), FORMAT_HTML, array('noclean' => true));
$block18introtitle = format_text(theme_universe_get_setting('block18introtitle'),
      FORMAT_HTML,
      array('noclean' => true));
$block18introcontent = format_text(theme_universe_get_setting('block18introcontent'),
      FORMAT_HTML,
      array('noclean' => true));
$block18html = format_text(theme_universe_get_setting('block18htmlcontent'),
      FORMAT_HTML,
      array('noclean' => true));
$block18footer = format_text(theme_universe_get_setting('block18footercontent'),
      FORMAT_HTML,
      array('noclean' => true));
$block18class = theme_universe_get_setting('block18class');
$block18css = theme_universe_get_setting('block18customcss');

$block18customcss = '';
if (!empty($block18css)) {
      $block18customcss = ' style="' . $block18css . '"';
} else {
      $block18customcss = null;
}

// Customm ID for the block.
$block18customid = theme_universe_get_setting('block18id');
$fpblockid18 = 'block18';
if (!empty($block18customid)) {
    $fpblockid18 = $block18customid;
}
// End.

echo '<!-- Start Block 18-->';
echo '<div id="' . $fpblockid19 . '" class="wrapper-lg rui-block-margin-top rui-fp-block--18 ' . $block18class . '"' . $block18customcss . '>';
if (!empty($block18introtitle) || !empty($block18introcontent)) {
      echo '<div class="wrapper-sm rui-fp-block-mb">';
}
if (!empty($block18introsubtitle)) {
    echo '<h4 class="rui-block-subtitle">' . $block18introsubtitle . '</h4>';
}
if (!empty($block18introtitle)) {
      echo '<h3 class="rui-block-title">' . $block18introtitle . '</h3>';
}
if (!empty($block18introcontent)) {
      echo '<div class="rui-block-desc">' . $block18introcontent . '</div>';
}
if (!empty($block18introtitle) || !empty($block18introcontent)) {
      echo '</div>';
}

echo '<div class="wrapper-fw">' . $block18html . '</div>';

$block18count = theme_universe_get_setting('block18count');
echo '<div class="wrapper-md mt-6">';
echo '<div class="accordion" id="block18Accordion">';
for ($i = 1; $i <= $block18count; $i++) {

      $q = format_text(theme_universe_get_setting("block18question" . $i),
            FORMAT_HTML, array('noclean' => true));
      $a = format_text(theme_universe_get_setting("block18answer" . $i),
            FORMAT_HTML, array('noclean' => true));
      echo '<div class="accordion-item">';
      echo '<h3 class="accordion-header" id="heading' .
            $i .
            '">';
      echo '<button class="accordion-button collapsed"
            type="button" data-toggle="collapse"
            data-target="#collapse' .
            $i .
            '" aria-expanded="false" aria-controls="collapse' .
            $i .
            '">';
      echo $q;
      echo '</button>';
      echo '</h3>';
      echo '<div id="collapse' .
            $i .
            '" class="accordion-collapse collapse" aria-labelledby="heading' .
            $i .
            '" data-parent="#block18Accordion">';
      echo '<div class="accordion-body">';
      echo $a;
      echo '</div>';
      echo '</div>';
      echo '</div>';
}
echo '</div><!-- accortion-->';
echo '</div><!-- wrapper-md -->';

if (!empty($block18footer)) {
      echo '<div class="rui-block-footer wrapper-md">' . $block18footer . '</div>';
}

echo '</div>';
if (theme_universe_get_setting("displayhrblock18") == '1') {
      echo '<hr class="rui-block-hr" />';
}
echo '<!-- End Block 18 -->';
