<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universe
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */


defined('MOODLE_INTERNAL') || die();

$page = new admin_settingpage('theme_universe_block15', get_string('settingsblock15', 'theme_universe'));

$name = 'theme_universe/displayblock15';
$title = get_string('turnon', 'theme_universe');
$description = get_string('displayblock15_desc', 'theme_universe');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title .
'<span class="badge badge-sq badge-dark ml-2">Block #15</span>', $description, $default);
$page->add($setting);

$name = 'theme_universe/displayhrblock15';
$title = get_string('displayblockhr', 'theme_universe');
$description = get_string('displayblockhr_desc', 'theme_universe');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block15id';
$title = get_string('additionalid', 'theme_universe');
$description = get_string('additionalid_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block15class';
$title = get_string('additionalclass', 'theme_universe');
$description = get_string('additionalclass_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block15introsubtitle';
$title = get_string('blockintrosubtitle', 'theme_universe');
$description = get_string('blockintrosubtitle_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block15introtitle';
$title = get_string('blockintrotitle', 'theme_universe');
$description = get_string('blockintrotitle_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block15introcontent';
$title = get_string('blockintrocontent', 'theme_universe');
$description = get_string('blockintrocontent_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block15htmlcontent';
$title = get_string('blockhtmlcontent', 'theme_universe');
$description = get_string('blockhtmlcontent_desc', 'theme_universe');
$default = '<div class="wrapper-fw rui-block-logotypes-1">
<div class="w-lg-65 text-center mx-lg-auto">
<!-- Heading -->
<div class="mb-2">
<p class="rui-block-text--1">Universities all around the world love my Moodle Templates.&nbsp;</p>
</div>
<!-- End Heading -->
<p class="rui-block-text--light rui-block-text--3 mt-2 mb-3">Trusted by hundreds of customers</p>
<div class="rui-img-mask row justify-content-center align-items-center">
<div class="rui-img-mask--grayscale col-auto col-sm py-3 text-center">
<img src="https://assets.rosea.io/universe/demo/logo180x90.png" alt="Logo" width="106" height="60" class="img-fluid">
</div>
<div class="rui-img-mask--grayscale col-auto col-sm py-3 text-center">
<img src="https://assets.rosea.io/universe/demo/logo180x90.png" alt="Logo" width="206" height="80" class="img-fluid">
</div>
<div class="rui-img-mask--grayscale col-auto col-sm py-3 text-center">
<img src="https://assets.rosea.io/universe/demo/logo180x90.png" alt="Logo" width="69" height="80" class="atto_image_button_middle">
</div>
<div class="rui-img-mask--grayscale col-auto col-sm py-3 text-center">
<img src="https://assets.rosea.io/universe/demo/logo180x90.png" alt="Logo" width="386" height="80" class="img-fluid">
</div>
<div class="rui-img-mask--grayscale col-auto col-sm py-3 text-center">
<img src="https://assets.rosea.io/universe/demo/logo180x90.png" alt="Logo" width="96" height="80" class="img-fluid">
</div>
</div>
</div>
</div>';
$setting = new universe_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block15footercontent';
$title = get_string('blockfootercontent', 'theme_universe');
$description = get_string('blockfootercontent_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$fileid = 'block15bg';
$name = 'theme_universe/block15bg';
$title = get_string('blockbg', 'theme_universe');
$description = get_string('blockbg_desc', 'theme_universe');
$opts = array('accepted_types' => array('.png', '.jpg', '.gif', '.webp', '.tiff', '.svg'), 'maxfiles' => 1);
$setting = new admin_setting_configstoredfile($name, $title, $description, $fileid, 0, $opts);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/block15customcss';
$title = get_string('blockcustomcss', 'theme_universe');
$description = get_string('blockcustomcss_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$settings->add($page);
