<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universe
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */

defined('MOODLE_INTERNAL') || die();
global $PAGE, $OUTPUT;
// Variables - Settings.
$block6introsubtitle = format_text(theme_universe_get_setting('block6introsubtitle'), FORMAT_HTML, array('noclean' => true));
$block6introtitle = format_text(theme_universe_get_setting('block6introtitle'), FORMAT_HTML, array('noclean' => true));
$block6introcontent = format_text(theme_universe_get_setting('block6introcontent'), FORMAT_HTML, array('noclean' => true));
$block6html = format_text(theme_universe_get_setting('block6htmlcontent'), FORMAT_HTML, array('noclean' => true));
$block6footer = format_text(theme_universe_get_setting('block6footercontent'), FORMAT_HTML, array('noclean' => true));
$block6class = theme_universe_get_setting('block6class');

$block6css = theme_universe_get_setting('block6customcss');
$block6customcss = '';
if (!empty($block6css)) {
    $block6customcss = ' style="' . $block6css . '"';
} else {
    $block6customcss = null;
}

// Customm ID for the block.
$block6customid = theme_universe_get_setting('block6id');
$fpblockid6 = 'block6';
if (!empty($block6customid)) {
    $fpblockid6 = $block6customid;
}
// End.

echo '<!-- Start Block 6-->';
echo '<div id="' . $fpblockid6 . '" class="wrapper-lg rui-block-margin-top rui-fp-block--6 ' . $block6class . '"' . $block6customcss . '>';
if (!empty($block6introtitle) || !empty($block6introcontent)) {
    echo '<div class="wrapper-sm rui-fp-block-mb">';
}
if (!empty($block6introsubtitle)) {
    echo '<h4 class="rui-block-subtitle">' . $block6introsubtitle . '</h4>';
}
if (!empty($block6introtitle)) {
    echo '<h3 class="rui-block-title">' . $block6introtitle . '</h3>';
}
if (!empty($block6introcontent)) {
    echo '<div class="rui-block-desc">' . $block6introcontent . '</div>';
}
if (!empty($block6introtitle) || !empty($block6introcontent)) {
    echo '</div>';
}
echo $block6html;
if (!empty($block6footer)) {
    echo '<div class="rui-block-footer wrapper-fw">' . $block6footer . '</div>';
}
echo '</div>';
if (theme_universe_get_setting("displayhrblock6") == '1') {
    echo '<hr class="rui-block-hr" />';
}
echo '<!-- End Block 6 -->';
