<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universe
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */


defined('MOODLE_INTERNAL') || die();

$page = new admin_settingpage('theme_universe_block4', get_string('settingsblock4', 'theme_universe'));

$name = 'theme_universe/displayblock4';
$title = get_string('turnon', 'theme_universe');
$description = get_string('displayblock4_desc', 'theme_universe');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title .
'<span class="badge badge-sq badge-dark ml-2">Block #4 (Slider)</span>', $description, $default);
$page->add($setting);

$name = 'theme_universe/block4fw';
$title = get_string('blockfw', 'theme_universe');
$description = get_string('blockfw_desc', 'theme_universe');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block4id';
$title = get_string('additionalid', 'theme_universe');
$description = get_string('additionalid_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block4class';
$title = get_string('additionalclass', 'theme_universe');
$description = get_string('additionalclass_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block4wrapperalign';
$title = get_string('block4wrapperalign', 'theme_universe');
$description = get_string('block4wrapperalign_desc', 'theme_universe');
$default = 1;
$choices = array(0 => 'Left', 1 => 'Middle', 2 => 'Right');
$setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
$page->add($setting);

$name = 'theme_universe/block4herotitlesize';
$title = get_string('blocktitlesize', 'theme_universe');
$description = get_string('blocktitlesize_desc', 'theme_universe');
$default = 1;
$choices = array(0 => 'Normal', 1 => 'Large', 2 => 'Extra Large');
$setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
$page->add($setting);

$name = 'theme_universe/block4herotitlecolor';
$title = get_string('blocktitlecolor', 'theme_universe');
$description = get_string('blocktitlecolor_desc', 'theme_universe');
$default = 1;
$choices = array(0 => 'White', 1 => 'Black', 2 => 'Gradient');
$setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
$page->add($setting);

$name = 'theme_universe/block4herotitleweight';
$title = get_string('blocktitleweight', 'theme_universe');
$description = get_string('blocktitleweight_desc', 'theme_universe');
$default = 1;
$choices = array(0 => 'Normal', 1 => 'Medium', 2 => 'Bold');
$setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
$page->add($setting);

$name = 'theme_universe/showblock4sliderwrapper';
$title = get_string('showblock4sliderwrapper', 'theme_universe');
$description = get_string('showblock4sliderwrapper_desc', 'theme_universe');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block4sliderwrapperbg';
$title = get_string('block4sliderwrapperbg', 'theme_universe');
$description = get_string('block4sliderwrapperbg_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/block4sliderinterval';
$title = get_string('sliderinterval', 'theme_universe');
$description = get_string('sliderinterval_desc', 'theme_universe');
$default = '6000';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block4count';
$title = get_string('block4count', 'theme_universe');
$description = get_string('block4count_desc', 'theme_universe');
$default = 1;
$options = array();
for ($i = 1; $i <= 7; $i++) {
    $options[$i] = $i;
}
$setting = new admin_setting_configselect($name, $title, $description, $default, $options);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

// If we don't have an slide yet, default to the preset.
$slidercount = get_config('theme_universe', 'block4count');

if (!$slidercount) {
    $slidercount = 1;
}

for ($sliderindex = 1; $sliderindex <= $slidercount; $sliderindex++) {
    $name = 'theme_universe/hblock4slide' . $sliderindex;
    $heading = get_string('hblock4slide', 'theme_universe');
    $title = get_string('hblock4slide_desc', 'theme_universe');
    $setting = new admin_setting_heading($name, '<span class="rui-admin-no">' .
        $sliderindex .
        '</span>' .
        $heading, format_text($title, FORMAT_MARKDOWN));
    $page->add($setting);

    $fileid = 'block4slideimg' . $sliderindex;
    $name = 'theme_universe/block4slideimg' . $sliderindex;
    $title = get_string('block4slideimg', 'theme_universe');
    $description = get_string('block4slideimg_desc', 'theme_universe');
    $opts = array('accepted_types' => array('.png', '.jpg', '.gif', '.webp', '.tiff', '.svg'), 'maxfiles' => 1);
    $setting = new admin_setting_configstoredfile($name, '<span class="rui-admin-no">' .
        $sliderindex .
        '</span>' .
        $title, $description, $fileid, 0, $opts);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $page->add($setting);

    $name = 'theme_universe/block4slidesubtitle' . $sliderindex;
    $title = get_string('blockintrosubtitle', 'theme_universe');
    $description = get_string('blockintrosubtitle_desc', 'theme_universe');
    $setting = new admin_setting_configtext($name, '<span class="rui-admin-no">' .
        $sliderindex .
        '</span>' .
        $title, $description, '', PARAM_TEXT);
    $page->add($setting);

    $name = 'theme_universe/block4slidetitle' . $sliderindex;
    $title = get_string('block4slidetitle', 'theme_universe');
    $description = get_string('block4slidetitle_desc', 'theme_universe');
    $setting = new admin_setting_configtext($name, '<span class="rui-admin-no">' .
        $sliderindex .
        '</span>' .
        $title, $description, '', PARAM_TEXT);
    $page->add($setting);

    $name = 'theme_universe/block4slidecaption' . $sliderindex;
    $title = get_string('block4slidecaption', 'theme_universe');
    $description = get_string('block4slidecaption_desc', 'theme_universe');
    $default = '';
    $setting = new admin_setting_confightmleditor($name, '<span class="rui-admin-no">' .
    $sliderindex .
    '</span>' .
    $title, $description, $default);
    $page->add($setting);

    $name = 'theme_universe/block4slidecss' . $sliderindex;
    $title = get_string('block4slidecss', 'theme_universe');
    $description = get_string('block4slidecss_desc', 'theme_universe');
    $setting = new admin_setting_configtextarea($name, '<span class="rui-admin-no">' .
    $sliderindex .
    '</span>' .
    $title, $description, '', PARAM_TEXT);
    $page->add($setting);
}

$settings->add($page);
