<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universe
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */


defined('MOODLE_INTERNAL') || die();

$page = new admin_settingpage('theme_universe_block20', get_string('settingsblock20', 'theme_universe'));

$name = 'theme_universe/displayblock20';
$title = get_string('turnon', 'theme_universe');
$description = get_string('displayblock20_desc', 'theme_universe');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title .
    '<span class="badge badge-sq badge-dark ml-2">Block #20</span>', $description, $default);
$page->add($setting);

$name = 'theme_universe/displayhrblock20';
$title = get_string('displayblockhr', 'theme_universe');
$description = get_string('displayblockhr_desc', 'theme_universe');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block20id';
$title = get_string('additionalid', 'theme_universe');
$description = get_string('additionalid_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block20class';
$title = get_string('additionalclass', 'theme_universe');
$description = get_string('additionalclass_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block20textalign';
$title = get_string('blocktextalign', 'theme_universe');
$description = get_string('blocktextalign_desc', 'theme_universe');
$options = [];
$options['left'] = get_string('left', 'theme_universe');
$options['center'] = get_string('center', 'theme_universe');
$options['right'] = get_string('right', 'theme_universe');
$setting = new admin_setting_configselect($name, $title, $description, 'center', $options);
$page->add($setting);

$name = 'theme_universe/block20introsubtitle';
$title = get_string('blockintrosubtitle', 'theme_universe');
$description = get_string('blockintrosubtitle_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block20introtitle';
$title = get_string('blockintrotitle', 'theme_universe');
$description = get_string('blockintrotitle_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block20titlesize';
$title = get_string('blocktitlesize', 'theme_universe');
$description = get_string('blocktitlesize_desc', 'theme_universe');
$default = 1;
$choices = array(0 => 'Normal', 1 => 'Large', 2 => 'Extra Large');
$setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
$page->add($setting);

$name = 'theme_universe/block20titlecolor';
$title = get_string('blocktitlecolor', 'theme_universe');
$description = get_string('blocktitlecolor_desc', 'theme_universe');
$default = 1;
$choices = array(0 => 'White', 1 => 'Black', 2 => 'Gradient');
$setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
$page->add($setting);

$name = 'theme_universe/block20titleweight';
$title = get_string('blocktitleweight', 'theme_universe');
$description = get_string('blocktitleweight_desc', 'theme_universe');
$default = 1;
$choices = array(0 => 'Normal', 1 => 'Medium', 2 => 'Bold');
$setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
$page->add($setting);

$name = 'theme_universe/block20introcontent';
$title = get_string('blockintrocontent', 'theme_universe');
$description = get_string('blockintrocontent_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block20htmlcontent';
$title = get_string('blockhtmlcontent', 'theme_universe');
$description = get_string('blockhtmlcontent_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block20footercontent';
$title = get_string('blockfootercontent', 'theme_universe');
$description = get_string('blockfootercontent_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$fileid = 'block20bg';
$name = 'theme_universe/block20bg';
$title = get_string('blockbg', 'theme_universe');
$description = get_string('blockbg_desc', 'theme_universe');
$opts = array('accepted_types' => array('.png', '.jpg', '.gif', '.webp', '.tiff', '.svg'), 'maxfiles' => 1);
$setting = new admin_setting_configstoredfile($name, $title, $description, $fileid, 0, $opts);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/block20customcss';
$title = get_string('blockcustomcss', 'theme_universe');
$description = get_string('blockcustomcss_desc', 'theme_universe');
$default = 'background: linear-gradient(to top right, #9f9ef6, #feedba);';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$settings->add($page);
