<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universe
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */


defined('MOODLE_INTERNAL') || die();

$page = new admin_settingpage('theme_universe_block18', get_string('settingsblock18', 'theme_universe'));

$name = 'theme_universe/displayblock18';
$title = get_string('turnon', 'theme_universe');
$description = get_string('displayblock18_desc', 'theme_universe');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title .
'<span class="badge badge-sq badge-dark ml-2">Block #18</span>', $description, $default);
$page->add($setting);

$name = 'theme_universe/displayhrblock18';
$title = get_string('displayblockhr', 'theme_universe');
$description = get_string('displayblockhr_desc', 'theme_universe');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block18id';
$title = get_string('additionalid', 'theme_universe');
$description = get_string('additionalid_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block18class';
$title = get_string('additionalclass', 'theme_universe');
$description = get_string('additionalclass_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block18introsubtitle';
$title = get_string('blockintrosubtitle', 'theme_universe');
$description = get_string('blockintrosubtitle_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block18introtitle';
$title = get_string('blockintrotitle', 'theme_universe');
$description = get_string('blockintrotitle_desc', 'theme_universe');
$default = 'Help & Support';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block18introcontent';
$title = get_string('blockintrocontent', 'theme_universe');
$description = get_string('blockintrocontent_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block18footercontent';
$title = get_string('blockfootercontent', 'theme_universe');
$description = get_string('blockfootercontent_desc', 'theme_universe');
$default = 'Lorem ipsum dolar set...';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/hblock18';
$heading = get_string('hblock18', 'theme_universe');
$title = get_string('hblock18_desc', 'theme_universe');
$setting = new admin_setting_heading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universe/block18htmlcontent';
$title = get_string('blockhtmlcontent', 'theme_universe');
$description = get_string('blockhtmlcontent_desc', 'theme_universe');
$default = '';
$setting = new universe_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block18customcss';
$title = get_string('blockcustomcss', 'theme_universe');
$description = get_string('blockcustomcss_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/hblock18_2';
$heading = get_string('hblock18_2', 'theme_universe');
$title = get_string('hblock18_2_desc', 'theme_universe');
$setting = new admin_setting_heading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universe/block18count';
$title = get_string('block18count', 'theme_universe');
$description = get_string('block18count_desc', 'theme_universe');
$default = 1;
$options = array();
for ($i = 1; $i <= 20; $i++) {
    $options[$i] = $i;
}
$setting = new admin_setting_configselect($name, $title, $description, $default, $options);
$page->add($setting);

$block18count = get_config('theme_universe', 'block18count');

if (!$block18count) {
    $block18count = 1;
}

for ($block18index = 1; $block18index <= $block18count; $block18index++) {
    $name = 'theme_universe/block18question' . $block18index;
    $title = get_string('block18question', 'theme_universe');
    $description = get_string('block18question_desc', 'theme_universe');
    $default = '';
    $setting = new admin_setting_configtextarea($name, '<span class="rui-admin-no">'.
    $block18index .
    '</span>' .
    $title, $description, $default);
    $page->add($setting);

    $name = 'theme_universe/block18answer' . $block18index;
    $title = get_string('block18answer', 'theme_universe');
    $description = get_string('block18answer_desc', 'theme_universe');
    $default = '';
    $setting = new universe_setting_confightmleditor($name, '<span class="rui-admin-no">' .
    $block18index .
    '</span>' .
    $title, $description, $default);
    $page->add($setting);
}

$settings->add($page);
