<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universechild
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */


defined('MOODLE_INTERNAL') || die();

$page = new admin_settingpage('theme_universechild_block11', get_string('settingsblock11', 'theme_universechild'));

$name = 'theme_universechild/displayblock11';
$title = get_string('turnon', 'theme_universechild');
$description = get_string('displayblock11_desc', 'theme_universechild');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title .
'<span class="badge badge-sq badge-dark ml-2">Block #11</span>', $description, $default);
$page->add($setting);

$name = 'theme_universechild/displayhrblock11';
$title = get_string('displayblockhr', 'theme_universechild');
$description = get_string('displayblockhr_desc', 'theme_universechild');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block11id';
$title = get_string('additionalid', 'theme_universechild');
$description = get_string('additionalid_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block11class';
$title = get_string('additionalclass', 'theme_universechild');
$description = get_string('additionalclass_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block11introsubtitle';
$title = get_string('blockintrosubtitle', 'theme_universechild');
$description = get_string('blockintrosubtitle_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block11introtitle';
$title = get_string('blockintrotitle', 'theme_universechild');
$description = get_string('blockintrotitle_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block11introcontent';
$title = get_string('blockintrocontent', 'theme_universechild');
$description = get_string('blockintrocontent_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block11htmlcontent';
$title = get_string('blockhtmlcontent', 'theme_universechild');
$description = get_string('blockhtmlcontent_desc', 'theme_universechild');
$default = '<div class="row row-cols-1 row-cols-lg-2 mx-0 px-0">
<!-- Start item -->
<div class="rui-card-item col mb-4">
<div class="rui-card--colorized rui-rounded--lg text-center" style="background-color: #ffddd7;">
<div class="rui-card-body">
<!-- icon -->
<div class=" mb-3">
<svg width="90px" height="90px" stroke-width="1.5"
viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"
color="currentColor">
<path d="M12 21V7a2 2 0 012-2h7.4a.6.6 0 01.6.6v13.114M12 21V7a2 2
0 00-2-2H2.6a.6.6 0 00-.6.6v13.114M14 19h8M10 19H2" stroke="#000000"
stroke-width="1.5" stroke-linecap="round"></path>
<path d="M12 21a2 2 0 012-2M12 21a2 2 0 00-2-2" stroke="#000000"
stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
</svg>
</div>
<!-- end icon -->
<h3 class="display-3">Get started</h3>
<p class="text-size-lg mt-3">Check out the documentation page.</p>
<a href="#" class="btn btn-lg btn-dark mt-4">Lets get started</a>
</div>
</div>
</div>
<!-- End item -->
<!-- Start item -->
<div class="rui-card-item col mb-4">
<div class="rui-card--colorized rui-rounded--lg text-center" style="background-color: #feedba;">
<div class="rui-card-body">
<!-- icon -->
<div class="mb-3">
<svg width="90px" height="90px" stroke-width="1.5" viewBox="0 0 24 24"
fill="none" xmlns="http://www.w3.org/2000/svg" color="currentColor">
<path d="M10 15v4a2 2 0 01-2 2H4a2 2 0 01-2-2v-4a2 2 0 012-2h4a2 2 0
012 2zM16 5v4a2 2 0 01-2 2h-4a2 2 0 01-2-2V5a2 2 0 012-2h4a2 2 0 012
2zM22 15v4a2 2 0 01-2 2h-4a2 2 0 01-2-2v-4a2 2 0 012-2h4a2 2 0 012 2zM6
16v-3M12 6V3M18 16v-3" stroke="#000000" stroke-width="1.5"
stroke-linecap="round" stroke-linejoin="round"></path>
</svg>
</div>
<!-- end icon -->
<h3 class="display-3">Blocks Snippets</h3>
<p class="text-size-lg mt-3">Check the theme front page blocks snippets library.</p>
<a href="#" class="btn btn-lg btn-dark mt-4">Code snippets library</a>
</div>
</div>
</div>
<!-- End item -->
</div>';
$setting = new universechild_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block11footercontent';
$title = get_string('blockfootercontent', 'theme_universechild');
$description = get_string('blockfootercontent_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block11customcss';
$title = get_string('blockcustomcss', 'theme_universechild');
$description = get_string('blockcustomcss_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$settings->add($page);
