<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universechild
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */


defined('MOODLE_INTERNAL') || die();

$page = new admin_settingpage('theme_universechild_block21', get_string('settingsblock21', 'theme_universechild'));

$name = 'theme_universechild/displayblock21';
$title = get_string('turnon', 'theme_universechild');
$description = get_string('displayblock21_desc', 'theme_universechild');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title .
    '<span class="badge badge-sq badge-dark ml-2">Block #21</span>', $description, $default);
$page->add($setting);

$name = 'theme_universechild/block21id';
$title = get_string('additionalid', 'theme_universechild');
$description = get_string('additionalid_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block21class';
$title = get_string('additionalclass', 'theme_universechild');
$description = get_string('additionalclass_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block21textalign';
$title = get_string('blocktextalign', 'theme_universechild');
$description = get_string('blocktextalign_desc', 'theme_universechild');
$options = [];
$options['left'] = get_string('left', 'theme_universechild');
$options['center'] = get_string('center', 'theme_universechild');
$options['right'] = get_string('right', 'theme_universechild');
$setting = new admin_setting_configselect($name, $title, $description, 'center', $options);
$page->add($setting);

$name = 'theme_universechild/displayhrblock21';
$title = get_string('displayblockhr', 'theme_universechild');
$description = get_string('displayblockhr_desc', 'theme_universechild');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block21introsubtitle';
$title = get_string('blockintrosubtitle', 'theme_universechild');
$description = get_string('blockintrosubtitle_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block21introtitle';
$title = get_string('blockintrotitle', 'theme_universechild');
$description = get_string('blockintrotitle_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block21titlesize';
$title = get_string('blocktitlesize', 'theme_universechild');
$description = get_string('blocktitlesize_desc', 'theme_universechild');
$default = 1;
$choices = array(0 => 'Normal', 1 => 'Large', 2 => 'Extra Large');
$setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
$page->add($setting);

$name = 'theme_universechild/block21titlecolor';
$title = get_string('blocktitlecolor', 'theme_universechild');
$description = get_string('blocktitlecolor_desc', 'theme_universechild');
$default = 1;
$choices = array(0 => 'White', 1 => 'Black', 2 => 'Gradient');
$setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
$page->add($setting);

$name = 'theme_universechild/block21titleweight';
$title = get_string('blocktitleweight', 'theme_universechild');
$description = get_string('blocktitleweight_desc', 'theme_universechild');
$default = 1;
$choices = array(0 => 'Normal', 1 => 'Medium', 2 => 'Bold');
$setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
$page->add($setting);

$name = 'theme_universechild/block21introcontent';
$title = get_string('blockintrocontent', 'theme_universechild');
$description = get_string('blockintrocontent_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block21htmlcontent';
$title = get_string('blockhtmlcontent', 'theme_universechild');
$description = get_string('blockhtmlcontent_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$fileid = 'block21bg';
$name = 'theme_universechild/block21bg';
$title = get_string('blockbg', 'theme_universechild');
$description = get_string('blockbg_desc', 'theme_universechild');
$opts = array('accepted_types' => array('.png', '.jpg', '.gif', '.webp', '.tiff', '.svg'), 'maxfiles' => 1);
$setting = new admin_setting_configstoredfile($name, $title, $description, $fileid, 0, $opts);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/block21customcss';
$title = get_string('blockcustomcss', 'theme_universechild');
$description = get_string('blockcustomcss_desc', 'theme_universechild');
$default = 'background-size: cover; background-position: center;';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$settings->add($page);
