<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universechild
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */

defined('MOODLE_INTERNAL') || die();
global $PAGE, $OUTPUT;

$fpblocks1 = $OUTPUT->blocks('fpblocks-t');
$hasfpblocks1 = (strpos($fpblocks1, 'data-block=') !== false);

// Customm ID for the block.
$block0customid = theme_universechild_get_setting('block0id');
$fpblockid0 = 'block0';
if (!empty($block0customid)) {
    $fpblockid0 = $block0customid;
}
// End.

if ($hasfpblocks1) {
    echo '<div id="fpblocks-t" class="wrapper-lg rui-block-margin-top my-0">';
}
echo $fpblocks1;

if ($hasfpblocks1) {
    echo '</div>';
}


echo '<div id="' . $fpblockid0 . '" class="wrapper-lg rui-block-margin-top">';
echo $OUTPUT->main_content();
echo '</div>';

$fpblocks2 = $OUTPUT->blocks('fpblocks-b');
$hasfpblocks2 = (strpos($fpblocks2, 'data-block=') !== false);

if ($hasfpblocks2) {
    echo '<div id="fpblocks-b" class="wrapper-lg rui-block-margin-top my-0">';
}
echo $fpblocks2;
if ($hasfpblocks2) {
    echo '</div>';
}
