<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universechild
 * @copyright 2024 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */

defined('MOODLE_INTERNAL') || die();

$page = new admin_settingpage('theme_universechild_settingscolorcustomization', get_string('settingscolorcustomization', 'theme_universechild'));

$name = 'theme_universechild/hcoursecolorcustom';
$heading = get_string('hcoursecolorcustom', 'theme_universechild', $a);
$setting = new universechild_setting_specialsettingheading($name, $heading,
    format_text(get_string('hcoursecolorcustom_desc', 'theme_universechild', $a), FORMAT_MARKDOWN));
$page->add($setting);

// Must add the page after definiting all the settings!
$settings->add($page);
