<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universechild
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */

defined('MOODLE_INTERNAL') || die();
global $PAGE, $OUTPUT;

// Variables - Settings.
$block14introsubtitle = format_text(theme_universechild_get_setting('block14introsubtitle'), FORMAT_HTML, array('noclean' => true));
$block14introtitle = format_text(theme_universechild_get_setting('block14introtitle'), FORMAT_HTML, array('noclean' => true));
$block14introcontent = format_text(theme_universechild_get_setting('block14introcontent'), FORMAT_HTML, array('noclean' => true));
$block14html = format_text(theme_universechild_get_setting('block14htmlcontent'), FORMAT_HTML, array('noclean' => true));
$block14footer = format_text(theme_universechild_get_setting('block14footercontent'), FORMAT_HTML, array('noclean' => true));
$block14class = theme_universechild_get_setting('block14class');
$block14img = $PAGE->theme->setting_file_url("block14bg", "block14bg");
$block14css = theme_universechild_get_setting('block14customcss');

$block14customcss = '';
if (!empty($block14css)) {
    $block14customcss = ' style="' . $block14css . '"';
}

if (!empty($block14img)) {
    $block14customcss = ' style="background-image: url(' . $block14img . ');" ';
}

// Customm ID for the block.
$block14customid = theme_universechild_get_setting('block14id');
$fpblockid14 = 'block14';
if (!empty($block14customid)) {
    $fpblockid14 = $block14customid;
}
// End.

echo '<!-- Start Block 14 -->';
echo '<div id="' . $fpblockid14 . '" class="wrapper-lg rui-block-margin-top rui-fp-block--14 ' . $block14class . '"' . $block14customcss . '>';

if (!empty($block14introtitle) || !empty($block14introcontent)) {
    echo '<div class="wrapper-sm rui-fp-block-mb">';
}
if (!empty($block14introsubtitle)) {
    echo '<h4 class="rui-block-subtitle">' . $block14introsubtitle . '</h4>';
}
if (!empty($block14introtitle)) {
    echo '<h3 class="rui-block-title">' . $block14introtitle . '</h3>';
}
if (!empty($block14introcontent)) {
    echo '<div class="rui-block-desc">' . $block14introcontent . '</div>';
}
if (!empty($block14introtitle) || !empty($block14introcontent)) {
    echo '</div>';
}
echo $block14html;

if (!empty($block14footer)) {
    echo '<div class="rui-block-footer wrapper-fw">' . $block14footer . '</div>';
}

echo '</div>';
if (theme_universechild_get_setting("displayhrblock14") == '1') {
    echo '<hr class="rui-block-hr" />';
}
echo '<!-- End Block 14 -->';
