<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universechild
 * @copyright Copyright © 2021 onwards Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */


defined('MOODLE_INTERNAL') || die();
$page = new admin_settingpage('theme_universechild_fontcustomization', get_string('settingsfontcustomization', 'theme_universechild'));

$name = 'theme_universechild/fontbody';
$title = get_string('fontbody', 'theme_universechild');
$description = get_string('fontbody_desc', 'theme_universechild');
$default = "'Inter', sans-serif";
$setting = new admin_setting_configtext($name, $title, $description, $default);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/fontweightregular';
$title = get_string('fontweightregular', 'theme_universechild');
$description = get_string('fontweightregular_desc', 'theme_universechild');
$default = '400';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/fontweightmedium';
$title = get_string('fontweightmedium', 'theme_universechild');
$description = get_string('fontweightmedium_desc', 'theme_universechild');
$default = '500';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/fontweightbold';
$title = get_string('fontweightbold', 'theme_universechild');
$description = get_string('fontweightbold_desc', 'theme_universechild');
$default = '700';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/fontweightheadings';
$title = get_string('fontweightheadings', 'theme_universechild');
$description = get_string('fontweightheadings_desc', 'theme_universechild');
$default = '700';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

// Google Font.
$name = 'theme_universechild/hgooglefont';
$heading = get_string('hgooglefont', 'theme_universechild');
$setting = new admin_setting_heading($name, $heading, format_text(get_string('hgooglefont_desc', 'theme_universechild'), FORMAT_MARKDOWN));
$page->add($setting);

// Google Font.
$name = 'theme_universechild/googlefonturl';
$title = get_string('googlefonturl', 'theme_universechild');
$description = get_string('googlefonturl_desc', 'theme_universechild');
$default = 'https://fonts.googleapis.com/css2?family=Inter:wght@400;500;700&display=swap';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

// Font files upload.
// Register the webfonts file types for filtering the uploads in the subsequent admin settings.
// This function call may return false. In this case, the filetypes were not registered and we
// can't restrict the filetypes in the subsequent admin settings unfortunately.
$name = 'theme_universechild/hcustomfont';
$heading = get_string('hcustomfont', 'theme_universechild');
$setting = new admin_setting_heading($name, $heading, format_text(get_string('hcustomfont_desc', 'theme_universechild'), FORMAT_MARKDOWN));
$page->add($setting);

$registerfontsresult = theme_universechild_register_webfonts_filetypes();

// Setting: Custom fonts.
$name = 'theme_universechild/fontfiles';
$title = get_string('fontfilessetting', 'theme_universechild', null, true);
$description = get_string('fontfilessetting_desc', 'theme_universechild', null, true);
if ($registerfontsresult == true) {
    $setting = new admin_setting_configstoredfile($name, $title, $description, 'fontfiles', 0,
            ['maxfiles' => -1, 'accepted_types' => theme_universechild_get_webfonts_extensions()]);
} else {
    $setting = new admin_setting_configstoredfile($name, $title, $description, 'fontfiles', 0,
            ['maxfiles' => -1]);
}
$page->add($setting);

// Information: Custom fonts list.
// If there is at least one file uploaded.
if (!empty(get_config('theme_universechild', 'fontfiles'))) {
    // Prepare the widget.
    $name = 'theme_universechild/customfontslist';
    $title = get_string('customfontslistsetting', 'theme_universechild', null, true);
    $description = get_string('customfontslistsetting_desc', 'theme_universechild', null, true);

    // Append the file list to the description.
    $templatecontext = ['files' => theme_universechild_get_customfonts_templatecontext()];
    $description .= $OUTPUT->render_from_template('theme_universechild/settings-customfonts-filelist', $templatecontext);

    // Finish the widget.
    $setting = new admin_setting_description($name, $title, $description);
    $page->add($setting);
}

$settings->add($page);
