<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universechild
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */

defined('MOODLE_INTERNAL') || die();
global $PAGE, $OUTPUT;

// Variables - Settings.
$block15introsubtitle = format_text(theme_universechild_get_setting('block15introsubtitle'), FORMAT_HTML, array('noclean' => true));
$block115introtitle = format_text(theme_universechild_get_setting('block115introtitle'), FORMAT_HTML, array('noclean' => true));
$block115introcontent = format_text(theme_universechild_get_setting('block115introcontent'), FORMAT_HTML, array('noclean' => true));
$block115html = format_text(theme_universechild_get_setting('block115htmlcontent'), FORMAT_HTML, array('noclean' => true));
$block115footer = format_text(theme_universechild_get_setting('block115footercontent'), FORMAT_HTML, array('noclean' => true));
$block115class = theme_universechild_get_setting('block115class');
$block115img = $PAGE->theme->setting_file_url("block115bg", "block115bg");
$block115css = theme_universechild_get_setting('block115customcss');

$block115customcss = '';

if (!empty($block115css)) {
    $block115customcss = ' style="' . $block115css . '"';
}

if (!empty($block115img)) {
    $block115customcss = ' style="background-image: url(' . $block115img . ');" ';
}

// Customm ID for the block.
$block115customid = theme_universechild_get_setting('block115id');
$fpblockid115 = 'block115';
if (!empty($block115customid)) {
    $fpblockid115 = $block115customid;
}
// End.

echo '<!-- Start Block 115 -->';
echo '<div id="' . $fpblockid115 . '" class="wrapper-lg rui-block-margin-top rui-fp-block--115 ' . $block115class . '"' . $block115customcss . '>';

if (!empty($block115introtitle) || !empty($block115introcontent)) {
    echo '<div class="wrapper-sm rui-fp-block-mb">';
}
if (!empty($block15introsubtitle)) {
    echo '<h4 class="rui-block-subtitle">' . $block15introsubtitle . '</h4>';
}
if (!empty($block115introtitle)) {
    echo '<h3 class="rui-block-title">' . $block115introtitle . '</h3>';
}
if (!empty($block115introcontent)) {
    echo '<div class="rui-block-desc">' . $block115introcontent . '</div>';
}
if (!empty($block115introtitle) || !empty($block115introcontent)) {
    echo '</div>';
}
echo $block115html;

if (!empty($block115footer)) {
    echo '<div class="rui-block-footer wrapper-fw">' . $block115footer . '</div>';
}

echo '</div>';
if (theme_universechild_get_setting("displayhrblock115") == '1') {
    echo '<hr class="rui-block-hr" />';
}
echo '<!-- End Block 115 -->';
