<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universechild
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */


defined('MOODLE_INTERNAL') || die();

$page = new admin_settingpage('theme_universechild_block13', get_string('settingsblock13', 'theme_universechild'));

$name = 'theme_universechild/displayblock13';
$title = get_string('turnon', 'theme_universechild');
$description = get_string('displayblock13_desc', 'theme_universechild');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title .
'<span class="badge badge-sq badge-dark ml-2">Block #13</span>', $description, $default);
$page->add($setting);

$name = 'theme_universechild/displayhrblock13';
$title = get_string('displayblockhr', 'theme_universechild');
$description = get_string('displayblockhr_desc', 'theme_universechild');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block13id';
$title = get_string('additionalid', 'theme_universechild');
$description = get_string('additionalid_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block13class';
$title = get_string('additionalclass', 'theme_universechild');
$description = get_string('additionalclass_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block13introsubtitle';
$title = get_string('blockintrosubtitle', 'theme_universechild');
$description = get_string('blockintrosubtitle_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block13introtitle';
$title = get_string('blockintrotitle', 'theme_universechild');
$description = get_string('blockintrotitle_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block13introcontent';
$title = get_string('blockintrocontent', 'theme_universechild');
$description = get_string('blockintrocontent_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block13htmlcontent';
$title = get_string('blockhtmlcontent', 'theme_universechild');
$description = get_string('blockhtmlcontent_desc', 'theme_universechild');
$default = '<div class="row align-items-lg-center">
<div class="col-12 col-lg">
<h2 class="mb-3">The best Moodle experience ever.</h2>
<p class="pb-3 mb-3">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse id lectus nec
nunc bibendum facilisis pellentesque ut eros. Praesent bibendum sed mi aliquet tempus.</p>
<div class="rui-img-mask row justify-content-center align-items-center mb-4">
<div class="rui-img-mask--grayscale col-auto col-sm py-3 text-center">
<img src="https://assets.rosea.io/universechild/demo/logo180x90.png" alt="" width="106" height="60" class="img-fluid">
</div>
<div class="rui-img-mask--grayscale col-auto col-sm py-3 text-center">
<img src="https://assets.rosea.io/universechild/demo/logo180x90.png" alt="" width="206" height="80" class="img-fluid">
</div>
<div class="rui-img-mask--grayscale col-auto col-sm py-3 text-center">
<img src="https://assets.rosea.io/universechild/demo/logo180x90.png" alt="" width="69" height="80" class="img-fluid">
</div>
</div>
<div class="d-flex flex-wrap">
<a class="btn btn-lg btn-primary" href="#">Try a free lesson</a>
<a class="btn btn-lg btn-outline-primary ml-md-2" href="#">Documentation</a>
</div>
</div>

<div class="rui-img-rounded--xl col-12 col-lg-6 mt-3 mt-lg-0 offset-lg-1">
<img src="https://assets.rosea.io/universechild/demo/600x600.jpg" alt="" width="600" height="600" class="img-fluid">
</div>

</div>';
$setting = new universechild_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block13footercontent';
$title = get_string('blockfootercontent', 'theme_universechild');
$description = get_string('blockfootercontent_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$fileid = 'block13bg';
$name = 'theme_universechild/block13bg';
$title = get_string('blockbg', 'theme_universechild');
$description = get_string('blockbg_desc', 'theme_universechild');
$opts = array('accepted_types' => array('.png', '.jpg', '.gif', '.webp', '.tiff', '.svg'), 'maxfiles' => 1);
$setting = new admin_setting_configstoredfile($name, $title, $description, $fileid, 0, $opts);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/block13customcss';
$title = get_string('blockcustomcss', 'theme_universechild');
$description = get_string('blockcustomcss_desc', 'theme_universechild');
$default = 'background: linear-gradient(to top right, #9f9ef6, #feedba); padding: 80px; text-align: center; border-radius: 80px;';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$settings->add($page);
