<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universechild
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */

defined('MOODLE_INTERNAL') || die();
global $PAGE, $OUTPUT;

// Variables - Settings.
$block19introsubtitle = format_text(theme_universechild_get_setting('block19introsubtitle'), FORMAT_HTML, array('noclean' => true));
$block19introtitle = format_text(theme_universechild_get_setting('block19introtitle'), FORMAT_HTML, array('noclean' => true));
$block19introcontent = format_text(theme_universechild_get_setting('block19introcontent'), FORMAT_HTML, array('noclean' => true));
$block19html = format_text(theme_universechild_get_setting('block19htmlcontent'), FORMAT_HTML, array('noclean' => true));
$block19footer = format_text(theme_universechild_get_setting('block19footercontent'), FORMAT_HTML, array('noclean' => true));
$block19class = theme_universechild_get_setting('block19class');
$block19css = theme_universechild_get_setting('block19customcss');

$block19customcss = '';
if (!empty($block19css)) {
    $block19customcss = ' style="' . $block19css . '"';
} else {
    $block19customcss = null;
}

// Customm ID for the block.
$block19customid = theme_universechild_get_setting('block19id');
$fpblockid19 = 'block19';
if (!empty($block19customid)) {
    $fpblockid19 = $block19customid;
}
// End.

echo '<!-- Start Block 19 -->';
echo '<div id="' . $fpblockid19 . '" class="wrapper-lg rui-block-margin-top rui-fp-block--19 ' . $block19class . '"' . $block19customcss . '>';
if (!empty($block19introtitle) || !empty($block19introcontent)) {
    echo '<div class="wrapper-sm rui-fp-block-mb">';
}
if (!empty($block19introsubtitle)) {
    echo '<h4 class="rui-block-subtitle">' . $block19introsubtitle . '</h4>';
}
if (!empty($block19introtitle)) {
    echo '<h3 class="rui-block-title">' . $block19introtitle . '</h3>';
}
if (!empty($block19introcontent)) {
    echo '<div class="rui-block-desc">' . $block19introcontent . '</div>';
}
if (!empty($block19introtitle) || !empty($block19introcontent)) {
    echo '</div>';
}
echo $block19html;
if (!empty($block19footer)) {
    echo '<div class="rui-block-footer wrapper-fw">' . $block19footer . '</div>';
}
echo '</div>';
if (theme_universechild_get_setting("displayhrblock19") == '1') {
    echo '<hr class="rui-block-hr" />';
}
echo '<!-- End Block 19 -->';
