<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universechild
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */

defined('MOODLE_INTERNAL') || die();
global $PAGE, $OUTPUT;

// Variables - Settings.
$block7introsubtitle = format_text(theme_universechild_get_setting('block7introsubtitle'), FORMAT_HTML, array('noclean' => true));
$block7introtitle = format_text(theme_universechild_get_setting('block7introtitle'), FORMAT_HTML, array('noclean' => true));
$block7introcontent = format_text(theme_universechild_get_setting('block7introcontent'), FORMAT_HTML, array('noclean' => true));
$block7html = format_text(theme_universechild_get_setting('block7htmlcontent'), FORMAT_HTML, array('noclean' => true));
$block7footer = format_text(theme_universechild_get_setting('block7footercontent'), FORMAT_HTML, array('noclean' => true));
$block7class = theme_universechild_get_setting('block7class');

$block7css = theme_universechild_get_setting('block7customcss');

$block7customcss = '';
if (!empty($block7css)) {
    $block7customcss = ' style="' . $block7css . '"';
} else {
    $block7customcss = null;
}

// Customm ID for the block.
$block7customid = theme_universechild_get_setting('block7id');
$fpblockid7 = 'block7';
if (!empty($block7customid)) {
    $fpblockid7 = $block7customid;
}
// End.

echo '<!-- Start Block 7 -->';
echo '<div id="' . $fpblockid7 . '" class="wrapper-lg rui-block-margin-top rui-fp-block--7 ' . $block7class . '"' . $block7customcss . '>';
if (!empty($block7introtitle) || !empty($block7introcontent)) {
    echo '<div class="wrapper-sm rui-fp-block-mb">';
}
if (!empty($block7introsubtitle)) {
    echo '<h4 class="rui-block-subtitle">' . $block7introsubtitle . '</h4>';
}
if (!empty($block7introtitle)) {
    echo '<h3 class="rui-block-title">' . $block7introtitle . '</h3>';
}
if (!empty($block7introcontent)) {
    echo '<div class="rui-block-desc">' . $block7introcontent . '</div>';
}
if (!empty($block7introtitle) || !empty($block7introcontent)) {
    echo '</div>';
}
echo $block7html;
if (!empty($block7footer)) {
    echo '<div class="rui-block-footer wrapper-fw">' . $block7footer . '</div>';
}
echo '</div>';
if (theme_universechild_get_setting("displayhrblock7") == '1') {
    echo '<hr class="rui-block-hr" />';
}
echo '<!-- End Block 7 -->';
