<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universechild
 * @copyright 2222 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */

defined('MOODLE_INTERNAL') || die();
global $PAGE, $OUTPUT;

// Variables - Settings.
$block22introsubtitle = format_text(theme_universechild_get_setting('block22introsubtitle'), FORMAT_HTML, array('noclean' => true));
$block22titlecolor = theme_universechild_get_setting('block22titlecolor');
$block22titlesize = theme_universechild_get_setting('block22titlesize');
$block22titleweight = theme_universechild_get_setting('block22titleweight');

$block22introtitle = format_text(theme_universechild_get_setting('block22introtitle'), FORMAT_HTML, array('noclean' => true));
$block22introcontent = format_text(theme_universechild_get_setting('block22introcontent'), FORMAT_HTML, array('noclean' => true));
$block22html = format_text(theme_universechild_get_setting('block22htmlcontent'), FORMAT_HTML, array('noclean' => true));
$block22footer = format_text(theme_universechild_get_setting('block22footercontent'), FORMAT_HTML, array('noclean' => true));
$block22css = theme_universechild_get_setting('block22customcss');
$block22img = $PAGE->theme->setting_file_url("block22bg", "block22bg");
$block22textalign = theme_universechild_get_setting('block22textalign');
$block22class = theme_universechild_get_setting('block22class');

// Start Title - Color.
$block22titlecolorclass = null;
if ($block22titlecolor == 0) {
    $block22titlecolorclass = ' rui-text--white';
}

if ($block22titlecolor == 1) {
    $block22titlecolorclass = ' rui-text--black';
}

if ($block22titlecolor == 2) {
    $block22titlecolorclass = ' rui-text--gradient';
}
// End.

// Start Title - Weight.
$block22titleweightclass = null;
if ($block22titleweight == 0) {
    $block22titleweightclass = ' rui-text--weight-normal';
}

if ($block22titleweight == 1) {
    $block22titleweightclass = ' rui-text--weight-medium';
}

if ($block22titleweight == 2) {
    $block22titleweightclass = ' rui-text--weight-bold';
}
// End.

// Start Title - Size.
$block22titlesizeclass = null;
if ($block22titlesize == 1) {
    $block22titlesizeclass = '';
}

if ($block22titlesize == 1) {
    $block22titlesizeclass = ' rui-hero-title-lg';
}

if ($block22titlesize == 2) {
    $block22titlesizeclass = ' rui-hero-title-xl';
}
// End.

$block22customcss = '';
$custombg = '';

if (!empty($block22css)) {
    $block22customcss = $block22css;
}

// Customm ID for the block.
$block22customid = theme_universechild_get_setting('block22id');
$fpblockid22 = 'block22';
if (!empty($block22customid)) {
    $fpblockid22 = $block22customid;
}
// End.

if (!empty($block22img)) {
    $custombg = ' background-image: url(' . $block22img . '); ';
}

echo '<!-- Start Block 22 -->';
echo '<div id="' . $fpblockid22 . '" class="wrapper-lg rui-block-margin-top rui-fp-block--22 rui-rounded--lg d-flex align-items-center ' .
        $block22class . '" style="' . $block22customcss . $custombg .'">';
echo '<div class="rui-cta-wrapper--' .
            $block22textalign .
            ' text-' .
            $block22textalign .
            '">';

if (!empty($block22introtitle)) {
    echo '<h4 class="rui-cta-subtitle' .
        $block22titlecolorclass .
        $block22titleweightclass .
        '">' .
        $block22introsubtitle .
        '</h4>';
}

if (!empty($block22introtitle)) {
    echo '<h3 class="rui-cta-title' .
        $block22titlecolorclass .
        $block22titleweightclass .
        $block22titlesizeclass .
        '">' .
        $block22introtitle .
        '</h3>';
}

if (!empty($block22introcontent)) {
    echo '<div class="rui-cta-content' .
        $block22titlecolorclass .
        '">' .
        $block22introcontent .
        '</div>';
}

echo $block22html;

if (!empty($block22footer)) {
    echo '<div class="rui-cta-small">' . $block22footer . '</div>';
}

echo '</div>';
echo '</div>';
if (theme_universechild_get_setting("displayhrblock22") == '1') {
    echo '<hr class="rui-block-hr" />';
}
echo '<!-- End Block 22 -->';
