<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universechild
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */

defined('MOODLE_INTERNAL') || die();
global $PAGE, $OUTPUT;

// Variables - Settings.
$block20introsubtitle = format_text(theme_universechild_get_setting('block20introsubtitle'), FORMAT_HTML, array('noclean' => true));
$block20titlecolor = theme_universechild_get_setting('block20titlecolor');
$block20titlesize = theme_universechild_get_setting('block20titlesize');
$block20titleweight = theme_universechild_get_setting('block20titleweight');

$block20introtitle = format_text(theme_universechild_get_setting('block20introtitle'), FORMAT_HTML, array('noclean' => true));
$block20introcontent = format_text(theme_universechild_get_setting('block20introcontent'), FORMAT_HTML, array('noclean' => true));
$block20html = format_text(theme_universechild_get_setting('block20htmlcontent'), FORMAT_HTML, array('noclean' => true));
$block20footer = format_text(theme_universechild_get_setting('block20footercontent'), FORMAT_HTML, array('noclean' => true));
$block20css = theme_universechild_get_setting('block20customcss');
$block20img = $PAGE->theme->setting_file_url("block20bg", "block20bg");
$block20textalign = theme_universechild_get_setting('block20textalign');
$block20class = theme_universechild_get_setting('block20class');

// Start Title - Color.
$block20titlecolorclass = null;
if ($block20titlecolor == 0) {
    $block20titlecolorclass = ' rui-text--white';
}

if ($block20titlecolor == 1) {
    $block20titlecolorclass = ' rui-text--black';
}

if ($block20titlecolor == 2) {
    $block20titlecolorclass = ' rui-text--gradient';
}
// End.

// Start Title - Weight.
$block20titleweightclass = null;
if ($block20titleweight == 0) {
    $block20titleweightclass = ' rui-text--weight-normal';
}

if ($block20titleweight == 1) {
    $block20titleweightclass = ' rui-text--weight-medium';
}

if ($block20titleweight == 2) {
    $block20titleweightclass = ' rui-text--weight-bold';
}
// End.

// Start Title - Size.
$block20titlesizeclass = null;
if ($block20titlesize == 1) {
    $block20titlesizeclass = '';
}

if ($block20titlesize == 1) {
    $block20titlesizeclass = ' rui-hero-title-lg';
}

if ($block20titlesize == 2) {
    $block20titlesizeclass = ' rui-hero-title-xl';
}
// End.

$block20customcss = '';
$custombg = '';

if (!empty($block20css)) {
    $block20customcss = $block20css;
}

// Customm ID for the block.
$block20customid = theme_universechild_get_setting('block20id');
$fpblockid20 = 'block20';
if (!empty($block20customid)) {
    $fpblockid20 = $block20customid;
}
// End.

if (!empty($block20img)) {
    $custombg = ' background-image: url(' . $block20img . '); ';
}

echo '<!-- Start Block 20 -->';
echo '<div id="' . $fpblockid20 . '" class="wrapper-lg rui-block-margin-top rui-fp-block--20 rui-rounded--lg d-flex align-items-center ' .
        $block20class . '" style="' . $block20customcss . $custombg .'">';
echo '<div class="rui-cta-wrapper--' .
            $block20textalign .
            ' text-' .
            $block20textalign .
            '">';

if (!empty($block20introtitle)) {
    echo '<h4 class="rui-cta-subtitle' .
        $block20titlecolorclass .
        $block20titleweightclass .
        '">' .
        $block20introsubtitle .
        '</h4>';
}

if (!empty($block20introtitle)) {
    echo '<h3 class="rui-cta-title' .
        $block20titlecolorclass .
        $block20titleweightclass .
        $block20titlesizeclass .
        '">' .
        $block20introtitle .
        '</h3>';
}

if (!empty($block20introcontent)) {
    echo '<div class="rui-cta-content' .
        $block20titlecolorclass .
        '">' .
        $block20introcontent .
        '</div>';
}

echo $block20html;

if (!empty($block20footer)) {
    echo '<div class="rui-cta-small">' . $block20footer . '</div>';
}

echo '</div>';
echo '</div>';
if (theme_universechild_get_setting("displayhrblock20") == '1') {
    echo '<hr class="rui-block-hr" />';
}
echo '<!-- End Block 20 -->';
