<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universechild
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */

defined('MOODLE_INTERNAL') || die();
global $PAGE, $OUTPUT;

// Variables - Settings.
$block11introsubtitle = format_text(theme_universechild_get_setting('block11introsubtitle'), FORMAT_HTML, array('noclean' => true));
$block11introtitle = format_text(theme_universechild_get_setting('block11introtitle'), FORMAT_HTML, array('noclean' => true));
$block11introcontent = format_text(theme_universechild_get_setting('block11introcontent'), FORMAT_HTML, array('noclean' => true));
$block11html = format_text(theme_universechild_get_setting('block11htmlcontent'), FORMAT_HTML, array('noclean' => true));
$block11footer = format_text(theme_universechild_get_setting('block11footercontent'), FORMAT_HTML, array('noclean' => true));
$block11class = theme_universechild_get_setting('block11class');

$block11css = theme_universechild_get_setting('block11customcss');

$block11customcss = '';
if (!empty($block11css)) {
    $block11customcss = ' style="' . $block11css . '"';
} else {
    $block11customcss = null;
}

// Customm ID for the block.
$block11customid = theme_universechild_get_setting('block11id');
$fpblockid11 = 'block11';
if (!empty($block11customid)) {
    $fpblockid11 = $block11customid;
}
// End.

echo '<!-- Start Block 11 -->';
echo '<div id="' . $fpblockid11 . '" class="wrapper-lg rui-block-margin-top rui-fp-block--11 ' . $block11class . '"' . $block11customcss . '>';

if (!empty($block11introtitle) || !empty($block11introcontent)) {
    echo '<div class="wrapper-sm rui-fp-block-mb">';
}
if (!empty($block11introsubtitle)) {
    echo '<h4 class="rui-block-subtitle">' . $block11introsubtitle . '</h4>';
}
if (!empty($block11introtitle)) {
    echo '<h3 class="rui-block-title">' . $block11introtitle . '</h3>';
}
if (!empty($block11introcontent)) {
    echo '<div class="rui-block-desc">' . $block11introcontent . '</div>';
}
if (!empty($block11introtitle) || !empty($block11introcontent)) {
    echo '</div>';
}
echo $block11html;

if (!empty($block11footer)) {
    echo '<div class="rui-block-footer wrapper-fw">' . $block11footer . '</div>';
}

echo '</div>';
if (theme_universechild_get_setting("displayhrblock11") == '1') {
    echo '<hr class="rui-block-hr" />';
}
echo '<!-- End Block 11 -->';
