<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universe
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */

defined('MOODLE_INTERNAL') || die();
global $PAGE, $OUTPUT;

// Variables - Settings.
$block8introsubtitle = format_text(theme_universe_get_setting('block8introsubtitle'), FORMAT_HTML, array('noclean' => true));
$block8introtitle = format_text(theme_universe_get_setting('block8introtitle'), FORMAT_HTML, array('noclean' => true));
$block8introcontent = format_text(theme_universe_get_setting('block8introcontent'), FORMAT_HTML, array('noclean' => true));
$block8html = format_text(theme_universe_get_setting('block8htmlcontent'), FORMAT_HTML, array('noclean' => true));
$block8footer = format_text(theme_universe_get_setting('block8footercontent'), FORMAT_HTML, array('noclean' => true));
$block8class = theme_universe_get_setting('block8class');

$block8css = theme_universe_get_setting('block8customcss');

$block8customcss = '';
if (!empty($block8css)) {
    $block8customcss = ' style="' . $block8css . '"';
} else {
    $block8customcss = null;
}

// Customm ID for the block.
$block8customid = theme_universe_get_setting('block8id');
$fpblockid8 = 'block8';
if (!empty($block8customid)) {
    $fpblockid8 = $block8customid;
}
// End.

echo '<!-- Start Block 8 -->';
echo '<div id="' . $fpblockid8 . '" class="wrapper-lg rui-block-margin-top rui-fp-block--8 ' . $block8class . '"' . $block8customcss . '>';
if (!empty($block8introtitle) || !empty($block8introcontent)) {
    echo '<div class="wrapper-sm rui-fp-block-mb">';
}
if (!empty($block8introsubtitle)) {
    echo '<h4 class="rui-block-subtitle">' . $block8introsubtitle . '</h4>';
}
if (!empty($block8introtitle)) {
    echo '<h3 class="rui-block-title">' . $block8introtitle . '</h3>';
}
if (!empty($block8introcontent)) {
    echo '<div class="rui-block-desc">' . $block8introcontent . '</div>';
}
if (!empty($block8introtitle) || !empty($block8introcontent)) {
    echo '</div>';
}
echo $block8html;
if (!empty($block8footer)) {
    echo '<div class="rui-block-footer wrapper-fw">' . $block8footer . '</div>';
}
echo '</div>';
if (theme_universe_get_setting("displayhrblock8") == '1') {
    echo '<hr class="rui-block-hr" />';
}
echo '<!-- End Block 8 -->';
