<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universechild
 * @copyright 2021 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */

defined('MOODLE_INTERNAL') || die();

$page = new admin_settingpage('theme_universechild_block2',
    get_string('settingsblock2', 'theme_universechild'));

$name = 'theme_universechild/displayblock2';
$title = get_string('turnon', 'theme_universechild');
$description = get_string('displayblock2_desc', 'theme_universechild');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title .
'<span class="badge badge-sq badge-dark ml-2">Block #2 (Hero Video)</span>', $description, $default);
$page->add($setting);

$name = 'theme_universechild/block2fw';
$title = get_string('blockfw', 'theme_universechild');
$description = get_string('blockfw_desc', 'theme_universechild');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block2id';
$title = get_string('additionalid', 'theme_universechild');
$description = get_string('additionalid_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block2class';
$title = get_string('additionalclass', 'theme_universechild');
$description = get_string('additionalclass_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block2wrapperalign';
$title = get_string('block2wrapperalign', 'theme_universechild');
$description = get_string('block2wrapperalign_desc', 'theme_universechild');
$default = 1;
$choices = array(0 => 'Left', 1 => 'Middle', 2 => 'Right');
$setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
$page->add($setting);

$name = 'theme_universechild/showblock2wrapper';
$title = get_string('showblock2wrapper', 'theme_universechild');
$description = get_string('showblock2wrapper_desc', 'theme_universechild');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block2wrapperbg';
$title = get_string('block2wrapperbg', 'theme_universechild');
$description = get_string('block2wrapperbg_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/block2introcontent';
$title = get_string('blockintrocontent', 'theme_universechild');
$description = get_string('blockintrocontent_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block2herosubtitle';
$title = get_string('blockintrosubtitle', 'theme_universechild');
$description = get_string('blockintrosubtitle_desc', 'theme_universechild');
$setting = new admin_setting_configtextarea($name, $title, $description, '', PARAM_TEXT);
$page->add($setting);

$name = 'theme_universechild/block2herotitle';
$title = get_string('blockintrotitle', 'theme_universechild');
$description = get_string('blockintrotitle_desc', 'theme_universechild');
$setting = new admin_setting_configtextarea($name, $title, $description, '', PARAM_TEXT);
$page->add($setting);

$name = 'theme_universechild/block2herotitlesize';
$title = get_string('blocktitlesize', 'theme_universechild');
$description = get_string('blocktitlesize_desc', 'theme_universechild');
$default = 1;
$choices = array(0 => 'Normal', 1 => 'Large', 2 => 'Extra Large');
$setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
$page->add($setting);

$name = 'theme_universechild/block2herotitlecolor';
$title = get_string('blocktitlecolor', 'theme_universechild');
$description = get_string('blocktitlecolor_desc', 'theme_universechild');
$default = 1;
$choices = array(0 => 'White', 1 => 'Black', 2 => 'Gradient');
$setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
$page->add($setting);

$name = 'theme_universechild/block2herotitleweight';
$title = get_string('blocktitleweight', 'theme_universechild');
$description = get_string('blocktitleweight_desc', 'theme_universechild');
$default = 1;
$choices = array(0 => 'Normal', 1 => 'Medium', 2 => 'Bold');
$setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
$page->add($setting);

$name = 'theme_universechild/block2herocaption';
$title = get_string('block2herocaption', 'theme_universechild');
$description = get_string('block2herocaption_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block2htmlcontent';
$title = get_string('blockhtmlcontent', 'theme_universechild');
$description = get_string('blockhtmlcontent_desc', 'theme_universechild');
$default = '';
$setting = new universechild_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block2footercontent';
$title = get_string('blockfootercontent', 'theme_universechild');
$description = get_string('blockfootercontent_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block2videoposter';
$title = get_string('block2videoposter', 'theme_universechild');
$description = get_string('block2videoposter_desc', 'theme_universechild');
$opts = array('accepted_types' => array('.jpg, .png, .gif'), 'maxfiles' => 1);
$setting = new admin_setting_configstoredfile($name, $title, $description, 'block2videoposter', 0, $opts);
$page->add($setting);

$name = 'theme_universechild/block2videomp4';
$title = get_string('block2videomp4', 'theme_universechild');
$description = get_string('block2videomp4_desc', 'theme_universechild');
$opts = array('accepted_types' => array('.mp4'), 'maxfiles' => 1);
$setting = new admin_setting_configstoredfile($name, $title, $description, 'block2videomp4', 0, $opts);
$page->add($setting);

$name = 'theme_universechild/block2videowebm';
$title = get_string('block2videowebm', 'theme_universechild');
$description = get_string('block2videowebm_desc', 'theme_universechild');
$opts = array('accepted_types' => array('.webm'), 'maxfiles' => 1);
$setting = new admin_setting_configstoredfile($name, $title, $description, 'block2videowebm', 0, $opts);
$page->add($setting);

$settings->add($page);
