<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universechild
 * @copyright 2024 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */

defined('MOODLE_INTERNAL') || die();

$page = new admin_settingpage('theme_universechild_settingscoursefilter', get_string('settingscoursefilter', 'theme_universechild'));

$name = 'theme_universechild/hcoursefilter';
$heading = get_string('hcoursefilter', 'theme_universechild', $a);
$setting = new universechild_setting_specialsettingheading($name, $heading,
    format_text(get_string('hcoursefilter_desc', 'theme_universechild', $a), FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universechild/showcoursefilter';
$title = get_string('showcoursefilter', 'theme_universechild');
$description = get_string('showcoursefilter_desc', 'theme_universechild');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/showlangfilter';
$title = get_string('showlangfilter', 'theme_universechild');
$description = get_string('showlangfilter_desc', 'theme_universechild');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/showteachersfilter';
$title = get_string('showteachersfilter', 'theme_universechild');
$description = get_string('showteachersfilter_desc', 'theme_universechild');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/customfilterfields';
$title = get_string('customfilterfields', 'theme_universechild');
$description = get_string('customfilterfields_desc', 'theme_universechild');
$setting = new admin_setting_heading($name, $title, $description);
$page->add($setting);

$name = 'theme_universechild/showfilter1';
$title = get_string('showfilter1', 'theme_universechild');
$description = get_string('showfilter1_desc', 'theme_universechild');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/customfilter1';
$title = get_string('customfilter1', 'theme_universechild');
$description = get_string('customfilter1_desc', 'theme_universechild');
$setting = new admin_setting_configtext($name, $title, $description, 'customfilter1');
$page->add($setting);

$name = 'theme_universechild/showfilter2';
$title = get_string('showfilter2', 'theme_universechild');
$description = get_string('showfilter2_desc', 'theme_universechild');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/customfilter2';
$title = get_string('customfilter2', 'theme_universechild');
$description = get_string('customfilter2_desc', 'theme_universechild');
$setting = new admin_setting_configtext($name, $title, $description, 'customfilter2');
$page->add($setting);

$name = 'theme_universechild/showfilter3';
$title = get_string('showfilter3', 'theme_universechild');
$description = get_string('showfilter3_desc', 'theme_universechild');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/customfilter3';
$title = get_string('customfilter3', 'theme_universechild');
$description = get_string('customfilter3_desc', 'theme_universechild');
$setting = new admin_setting_configtext($name, $title, $description, 'customfilter3');
$page->add($setting);

$name = 'theme_universechild/showfilter4';
$title = get_string('showfilter4', 'theme_universechild');
$description = get_string('showfilter4_desc', 'theme_universechild');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/customfilter4';
$title = get_string('customfilter4', 'theme_universechild');
$description = get_string('customfilter4_desc', 'theme_universechild');
$setting = new admin_setting_configtext($name, $title, $description, 'customfilter4');
$page->add($setting);

$name = 'theme_universechild/showfilter5';
$title = get_string('showfilter5', 'theme_universechild');
$description = get_string('showfilter5_desc', 'theme_universechild');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/customfilter5';
$title = get_string('customfilter5', 'theme_universechild');
$description = get_string('customfilter5_desc', 'theme_universechild');
$setting = new admin_setting_configtext($name, $title, $description, 'customfilter5');
$page->add($setting);

$name = 'theme_universechild/showfilter6';
$title = get_string('showfilter6', 'theme_universechild');
$description = get_string('showfilter6_desc', 'theme_universechild');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/customfilter6';
$title = get_string('customfilter6', 'theme_universechild');
$description = get_string('customfilter6_desc', 'theme_universechild');
$setting = new admin_setting_configtext($name, $title, $description, 'price');
$page->add($setting);

// Must add the page after definiting all the settings!
$settings->add($page);
