<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universechild
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */


defined('MOODLE_INTERNAL') || die();

$page = new admin_settingpage('theme_universechild_block17', get_string('settingsblock17', 'theme_universechild'));

$name = 'theme_universechild/displayblock17';
$title = get_string('turnon', 'theme_universechild');
$description = get_string('displayblock17_desc', 'theme_universechild');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title .
'<span class="badge badge-sq badge-dark ml-2">Block #17</span>', $description, $default);
$page->add($setting);

$name = 'theme_universechild/displayhrblock17';
$title = get_string('displayblockhr', 'theme_universechild');
$description = get_string('displayblockhr_desc', 'theme_universechild');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block17id';
$title = get_string('additionalid', 'theme_universechild');
$description = get_string('additionalid_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block17class';
$title = get_string('additionalclass', 'theme_universechild');
$description = get_string('additionalclass_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block17introsubtitle';
$title = get_string('blockintrosubtitle', 'theme_universechild');
$description = get_string('blockintrosubtitle_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block17introtitle';
$title = get_string('blockintrotitle', 'theme_universechild');
$description = get_string('blockintrotitle_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block17introcontent';
$title = get_string('blockintrocontent', 'theme_universechild');
$description = get_string('blockintrocontent_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block17htmlcontent';
$title = get_string('blockhtmlcontent', 'theme_universechild');
$description = get_string('blockhtmlcontent_desc', 'theme_universechild');
$default = '<!-- Start - Block - Team #1 -->
<div class="wrapper-fw">
<div class="rui-card-team-grid">
<!-- Start item -->
<div class="rui-block-team-item text-center text-md-left">
<div class="rui-img--anim-1 text-center">
<img src="https://assets.rosea.io/universechild/demo/600x800.png" alt="Team #1" width="600" height="800" class="img-fluid">
</div>
<h4 class="mt-3 mb-0" style="text-align: center;">Anna Johnson</h4>
<div class="rui-block-text--3 rui-block-text--light" style="text-align: center;">CEO</div>
<div class="rui-block-text--2 mt-2" style="text-align: center;">
Paneer cheesy feet when the cheese comes out everybodys happy.
</div>
</div>
<!-- End item -->

<!-- Start item -->
<div class="rui-block-team-item text-center text-md-left">
<div class="rui-img--anim-2 text-center">
<img src="https://assets.rosea.io/universechild/demo/600x800.png" alt="Team #2" width="600" height="800" class="img-fluid">
</div>
<h4 class="mt-3 mb-0" style="text-align: center;">
<p>Austin John</p>
</h4>
<div class="rui-block-text--3 rui-block-text--light" style="text-align: center;">Senior UI Designer</div>
<div class="rui-block-text--2 mt-2" style="text-align: center;">
Cheese on toast cheesy grin parmesan gouda Lancashire queso port-Salut parmesan.</div>
</div>
<!-- End item -->

<!-- Start item -->
<div class="rui-block-team-item text-center text-md-left">
<div class="rui-img--anim-3 text-center">
<img src="https://assets.rosea.io/universechild/demo/600x800.png" alt="Team #3" width="600" height="800" class="img-fluid"></div>
<h4 class="mt-3 mb-0" style="text-align: center;">Christa McAuliffe</h4>
<div class="rui-block-text--3 rui-block-text--light" style="text-align: center;">Product Manager</div>
<div class="rui-block-text--2 mt-2" style="text-align: center;">
Lancashire parmesan caerphilly croque monsieur fondue cheesy grin cheddar hard cheese.</div>
</div>
<!-- End item -->

<!-- Start item -->
<div class="rui-block-team-item text-center text-md-left">
<div class="rui-img--anim-4 text-center">
<img src="https://assets.rosea.io/universechild/demo/600x800.png" alt="Team #4" width="600" height="800" class="img-fluid">
</div>
<h4 class="mt-3 mb-0" style="text-align: center;">Maria Fox</h4>
<div class="rui-block-text--3 rui-block-text--light" style="text-align: center;">UX Designer</div>
<div class="rui-block-text--2 mt-2" style="text-align: center;">
Multidisciplinary. Drinks too much coffee. Likes sentence fragments.</div>
</div>
<!-- End item -->

</div>
<!-- End - Block - Team #1 -->
</div>';
$setting = new universechild_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block17footercontent';
$title = get_string('blockfootercontent', 'theme_universechild');
$description = get_string('blockfootercontent_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block17customcss';
$title = get_string('blockcustomcss', 'theme_universechild');
$description = get_string('blockcustomcss_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$settings->add($page);
