<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universe
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */

defined('MOODLE_INTERNAL') || die();
global $PAGE, $OUTPUT;

// Variables - Settings.
$block5introsubtitle = format_text(theme_universe_get_setting('block5introsubtitle'), FORMAT_HTML, array('noclean' => true));
$block5introtitle = format_text(theme_universe_get_setting('block5introtitle'), FORMAT_HTML, array('noclean' => true));
$block5introcontent = format_text(theme_universe_get_setting('block5introcontent'), FORMAT_HTML, array('noclean' => true));
$block5html = format_text(theme_universe_get_setting('block5htmlcontent'), FORMAT_HTML, array('noclean' => true));
$block5footer = format_text(theme_universe_get_setting('block5footercontent'), FORMAT_HTML, array('noclean' => true));
$block5class = theme_universe_get_setting('block5class');

$block5css = theme_universe_get_setting('block5customcss');

$block5customcss = '';
if (!empty($block5css)) {
    $block5customcss = ' style="' . $block5css . '"';
} else {
    $block5customcss = null;
}

// Customm ID for the block.
$block5customid = theme_universe_get_setting('block5id');
$fpblockid5 = 'block5';
if (!empty($block5customid)) {
    $fpblockid5 = $block5customid;
}
// End.

echo '<!-- Start Block 5 -->';
echo '<div id="' . $fpblockid5 . '" class="wrapper-lg rui-block-margin-top rui-fp-block--5 ' . $block5class . '"' . $block5customcss . '>';
if (!empty($block5introtitle) || !empty($block5introcontent)) {
    echo '<div class="wrapper-sm rui-fp-block-mb">';
}
if (!empty($block5introsubtitle)) {
    echo '<h4 class="rui-block-subtitle">' . $block5introsubtitle . '</h4>';
}
if (!empty($block5introtitle)) {
    echo '<h3 class="rui-block-title">' . $block5introtitle . '</h3>';
}
if (!empty($block5introcontent)) {
    echo '<div class="rui-block-desc">' . $block5introcontent . '</div>';
}
if (!empty($block5introtitle) || !empty($block5introcontent)) {
    echo '</div>';
}
echo $block5html;
if (!empty($block5footer)) {
    echo '<div class="rui-block-footer wrapper-fw">' . $block5footer . '</div>';
}
echo '</div>';
if (theme_universe_get_setting("displayhrblock5") == '1') {
    echo '<hr class="rui-block-hr" />';
}
echo '<!-- End Block 5 -->';
