<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universe
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */

defined('MOODLE_INTERNAL') || die();
global $PAGE, $OUTPUT;

// Variables - Settings.
$block13introsubtitle = format_text(theme_universe_get_setting('block13introsubtitle'), FORMAT_HTML, array('noclean' => true));
$block13introtitle = format_text(theme_universe_get_setting('block13introtitle'), FORMAT_HTML, array('noclean' => true));
$block13introcontent = format_text(theme_universe_get_setting('block13introcontent'), FORMAT_HTML, array('noclean' => true));
$block13html = format_text(theme_universe_get_setting('block13htmlcontent'), FORMAT_HTML, array('noclean' => true));
$block13footer = format_text(theme_universe_get_setting('block13footercontent'), FORMAT_HTML, array('noclean' => true));
$block13class = theme_universe_get_setting('block13class');
$block13img = $PAGE->theme->setting_file_url("block13bg", "block13bg");
$block13css = theme_universe_get_setting('block13customcss');

$block13customcss = '';

if (!empty($block13css)) {
    $block13customcss = ' style="' . $block13css . '"';
}

if (!empty($block13img)) {
    $block13customcss = ' style="background-image: url(' . $block13img . ');" ';
}

// Customm ID for the block.
$block13customid = theme_universe_get_setting('block13id');
$fpblockid13 = 'block13';
if (!empty($block13customid)) {
    $fpblockid13 = $block13customid;
}
// End.

echo '<!-- Start Block 13 -->';
echo '<div id="' . $fpblockid13 . '" class="wrapper-lg rui-block-margin-top rui-fp-block--13 ' . $block13class . '"' . $block13customcss . '>';

if (!empty($block13introtitle) || !empty($block13introcontent)) {
    echo '<div class="wrapper-sm rui-fp-block-mb">';
}
if (!empty($block13introsubtitle)) {
    echo '<h4 class="rui-block-subtitle">' . $block13introsubtitle . '</h4>';
}
if (!empty($block13introtitle)) {
    echo '<h3 class="rui-block-title">' . $block13introtitle . '</h3>';
}
if (!empty($block13introcontent)) {
    echo '<div class="rui-block-desc">' . $block13introcontent . '</div>';
}
if (!empty($block13introtitle) || !empty($block13introcontent)) {
    echo '</div>';
}
echo $block13html;

if (!empty($block13footer)) {
    echo '<div class="rui-block-footer wrapper-fw">' . $block13footer . '</div>';
}

echo '</div>';
if (theme_universe_get_setting("displayhrblock13") == '1') {
    echo '<hr class="rui-block-hr" />';
}
echo '<!-- End Block 13 -->';
