<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universechild
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */


defined('MOODLE_INTERNAL') || die();

$page = new admin_settingpage('theme_universechild_block5', get_string('settingsblock5', 'theme_universechild'));

$name = 'theme_universechild/displayblock5';
$title = get_string('turnon', 'theme_universechild');
$description = get_string('displayblock5_desc', 'theme_universechild');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title .
'<span class="badge badge-sq badge-dark ml-2">Block #5</span>', $description, $default);
$page->add($setting);

$name = 'theme_universechild/displayhrblock5';
$title = get_string('displayblockhr', 'theme_universechild');
$description = get_string('displayblockhr_desc', 'theme_universechild');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block5id';
$title = get_string('additionalid', 'theme_universechild');
$description = get_string('additionalid_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block5class';
$title = get_string('additionalclass', 'theme_universechild');
$description = get_string('additionalclass_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block5introsubtitle';
$title = get_string('blockintrosubtitle', 'theme_universechild');
$description = get_string('blockintrosubtitle_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block5introtitle';
$title = get_string('blockintrotitle', 'theme_universechild');
$description = get_string('blockintrotitle_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block5introcontent';
$title = get_string('blockintrocontent', 'theme_universechild');
$description = get_string('blockintrocontent_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block5htmlcontent';
$title = get_string('blockhtmlcontent', 'theme_universechild');
$description = get_string('blockhtmlcontent_desc', 'theme_universechild');
$default = '<!-- Start - Block -->
<div class="row row-cols-1 row-cols-md-2 row-cols-lg-4">
<!-- Start item -->
<div class="rui-card-item rui-img-rounded--lg col mb-4">
<img src="https://assets.rosea.io/universechild/demo/pattern.jpg" alt="Moodle - Dark Mode" width="800" height="800" class="img-fluid">
<div class="rui-color-card rui-rounded--lg">
<div class="rui-card-body">
<h3 class="rui-card-title">Activities</h3>
<p class="rui-card-text">An activity is a general name for a group of features in a Moodle course.</p>
</div>
</div>
</div>
<!-- End item -->

<!-- Start item -->
<div class="rui-card-item rui-img-rounded--lg col mb-4">
<img src="https://assets.rosea.io/universechild/demo/pattern.jpg" alt="unsplash" width="800" height="800" class="img-fluid">
<div class="rui-color-card rui-rounded--lg">
<div class="rui-card-body">
<h3 class="rui-card-title">Quizzes</h3>
<p class="rui-card-text">Just look how nice, simple, and easy the new quiz UI is. Completely redesigned.</p>
</div>
</div>
</div>
<!-- End item -->

<!-- Start item -->
<div class="rui-card-item rui-img-rounded--lg col mb-4">
<img src="https://assets.rosea.io/universechild/demo/pattern.jpg" alt="Unsplash" width="800" height="800" class="img-fluid">
<div class="rui-color-card rui-rounded--lg">
<div class="rui-card-body">
<h3 class="rui-card-title">Forums</h3>
<p class="rui-card-text">The Forum activity allows students and teachers to exchange ideas by posting</p>
</div>
</div>
</div>
<!-- End item -->

<!-- Start item -->
<div class="rui-card-item rui-img-rounded--lg col mb-4">
<img src="https://assets.rosea.io/universechild/demo/pattern.jpg" alt="Unsplash" width="800" height="800" class="img-fluid">
<div class="rui-color-card rui-rounded--lg">
<div class="rui-card-body">
<h3 class="rui-card-title">Assignments</h3>
<p class="rui-card-text">Assignments allow students to submit work to their teacher for grading.</p>
</div>
</div>
</div>
<!-- End item -->

</div>
<!-- End - Block -->';
$setting = new universechild_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block5footercontent';
$title = get_string('blockfootercontent', 'theme_universechild');
$description = get_string('blockfootercontent_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/block5customcss';
$title = get_string('blockcustomcss', 'theme_universechild');
$description = get_string('blockcustomcss_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$settings->add($page);
