<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universe
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */


defined('MOODLE_INTERNAL') || die();

$page = new admin_settingpage('theme_universe_customization', get_string('settingscustomization', 'theme_universe'));

$name = 'theme_universe/hgeneral';
$heading = get_string('hgeneral', 'theme_universe');
$title = get_string('hgeneral_desc', 'theme_universe');
$setting = new admin_setting_heading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universe/colorbodybg';
$title = get_string('colorbodybg', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorborder';
$title = get_string('colorborder', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/btnborderradius';
$title = get_string('btnborderradius', 'theme_universe');
$description = get_string('empty_desc', 'theme_universe');
$setting = new admin_setting_configtext($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/hcolorstxt';
$heading = get_string('hcolorstxt', 'theme_universe');
$title = get_string('hcolorstxt_desc', 'theme_universe');
$setting = new admin_setting_heading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universe/colorbody';
$title = get_string('colorbody', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorbodysecondary';
$title = get_string('colorbodysecondary', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorbodylight';
$title = get_string('colorbodylight', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorheadings';
$title = get_string('colorheadings', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorlink';
$title = get_string('colorlink', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorlinkhover';
$title = get_string('colorlinkhover', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorlink';
$title = get_string('colorlink', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorlinkhover';
$title = get_string('colorlinkhover', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/hcolorsprimary';
$heading = get_string('hcolorsprimary', 'theme_universe');
$title = get_string('hcolorsprimary_desc', 'theme_universe');
$setting = new admin_setting_heading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universe/colorprimary600';
$title = get_string('colorprimary600', 'theme_universe');
$description = get_string('colorprimary_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorprimary100';
$title = get_string('colorprimary100', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorprimary200';
$title = get_string('colorprimary200', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorprimary300';
$title = get_string('colorprimary300', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorprimary400';
$title = get_string('colorprimary400', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorprimary500';
$title = get_string('colorprimary500', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorprimary700';
$title = get_string('colorprimary700', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorprimary800';
$title = get_string('colorprimary800', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorprimary900';
$title = get_string('colorprimary900', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/hcolorsgrays';
$heading = get_string('hcolorsgrays', 'theme_universe');
$title = get_string('hcolorsgrays_desc', 'theme_universe');
$setting = new admin_setting_heading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universe/colorgray100';
$title = get_string('colorgray100', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorgray200';
$title = get_string('colorgray200', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorgray300';
$title = get_string('colorgray300', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorgray400';
$title = get_string('colorgray400', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorgray500';
$title = get_string('colorgray500', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorgray600';
$title = get_string('colorgray600', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorgray700';
$title = get_string('colorgray700', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorgray800';
$title = get_string('colorgray800', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorgray900';
$title = get_string('colorgray900', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/hdmgeneral';
$heading = get_string('hdmgeneral', 'theme_universe');
$setting = new admin_setting_heading($name, $heading, format_text(get_string('hgeneral_desc', 'theme_universe'), FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universe/dmcolorbodybg';
$title = get_string('dmcolorbodybg', 'theme_universe');
$description = get_string('dmcolor_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/dmcolorborder';
$title = get_string('dmcolorborder', 'theme_universe');
$description = get_string('dmcolor_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/hdmcolorstxt';
$heading = get_string('hdmcolorstxt', 'theme_universe');
$setting = new admin_setting_heading($name, $heading, format_text(get_string('hdmcolorstxt_desc', 'theme_universe'), FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universe/dmcolorbody';
$title = get_string('dmcolorbody', 'theme_universe');
$description = get_string('dmcolor_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/dmcolorbodysecondary';
$title = get_string('dmcolorbodysecondary', 'theme_universe');
$description = get_string('dmcolor_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/dmcolorbodylight';
$title = get_string('dmcolorbodylight', 'theme_universe');
$description = get_string('dmcolor_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/dmcolorheadings';
$title = get_string('dmcolorheadings', 'theme_universe');
$description = get_string('dmcolor_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/dmcolorgradientheading1';
$title = get_string('dmcolorgradientheading1', 'theme_universe');
$description = get_string('dmcolor_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/dmcolorgradientheading2';
$title = get_string('dmcolorgradientheading2', 'theme_universe');
$description = get_string('dmcolor_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/dmcolorlink';
$title = get_string('dmcolorlink', 'theme_universe');
$description = get_string('dmcolor_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/dmcolorlinkhover';
$title = get_string('dmcolorlinkhover', 'theme_universe');
$description = get_string('dmcolor_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/hdmcolorsgrays';
$heading = get_string('hdmcolorsgrays', 'theme_universe');
$setting = new admin_setting_heading($name, $heading, format_text(get_string('hdmcolorsgrays_desc', 'theme_universe'), FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universe/colorgray100';
$title = get_string('colorgray100', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorgray200';
$title = get_string('colorgray200', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorgray300';
$title = get_string('colorgray300', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorgray400';
$title = get_string('colorgray400', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorgray500';
$title = get_string('colorgray500', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorgray600';
$title = get_string('colorgray600', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorgray700';
$title = get_string('colorgray700', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorgray800';
$title = get_string('colorgray800', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/colorgray900';
$title = get_string('colorgray900', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$settings->add($page);
