<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universe
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */

defined('MOODLE_INTERNAL') || die();
global $PAGE, $OUTPUT;

// Variables - Settings.
$block17introsubtitle = format_text(theme_universe_get_setting('block17introsubtitle'), FORMAT_HTML, array('noclean' => true));
$block17introtitle = format_text(theme_universe_get_setting('block17introtitle'), FORMAT_HTML, array('noclean' => true));
$block17introcontent = format_text(theme_universe_get_setting('block17introcontent'), FORMAT_HTML, array('noclean' => true));
$block17html = format_text(theme_universe_get_setting('block17htmlcontent'), FORMAT_HTML, array('noclean' => true));
$block17footer = format_text(theme_universe_get_setting('block17footercontent'), FORMAT_HTML, array('noclean' => true));
$block17class = theme_universe_get_setting('block17class');
$block17css = theme_universe_get_setting('block17customcss');

$block17customcss = '';
if (!empty($block17css)) {
    $block17customcss = ' style="' . $block17css . '"';
} else {
    $block17customcss = null;
}

// Customm ID for the block.
$block17customid = theme_universe_get_setting('block17id');
$fpblockid17 = 'block17';
if (!empty($block17customid)) {
    $fpblockid17 = $block17customid;
}
// End.

echo '<!-- Start Block 17 -->';
echo '<div id="' . $fpblockid17 . '" class="wrapper-lg rui-block-margin-top rui-fp-block--17 ' . $block17class . '"' . $block17customcss . '>';

if (!empty($block17introtitle) || !empty($block17introcontent)) {
    echo '<div class="wrapper-sm rui-fp-block-mb">';
}
if (!empty($block17introsubtitle)) {
    echo '<h4 class="rui-block-subtitle">' . $block17introsubtitle . '</h4>';
}
if (!empty($block17introtitle)) {
    echo '<h3 class="rui-block-title">' . $block17introtitle . '</h3>';
}
if (!empty($block17introcontent)) {
    echo '<div class="rui-block-desc">' . $block17introcontent . '</div>';
}
if (!empty($block17introtitle) || !empty($block17introcontent)) {
    echo '</div>';
}
echo $block17html;
if (!empty($block17footer)) {
    echo '<div class="rui-block-footer wrapper-fw">' . $block17footer . '</div>';
}
echo '</div>';
if (theme_universe_get_setting("displayhrblock17") == '1') {
    echo '<hr class="rui-block-hr" />';
}
echo '<!-- End Block 17 -->';
