<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universe
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */


defined('MOODLE_INTERNAL') || die();

$page = new admin_settingpage('theme_universe_block7',
     get_string('settingsblock7', 'theme_universe'));

$name = 'theme_universe/displayblock7';
$title = get_string('turnon', 'theme_universe');
$description = get_string('displayblock7_desc', 'theme_universe');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title .
'<span class="badge badge-sq badge-dark ml-2">Block #7</span>', $description, $default);
$page->add($setting);

$name = 'theme_universe/displayhrblock7';
$title = get_string('displayblockhr', 'theme_universe');
$description = get_string('displayblockhr_desc', 'theme_universe');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block7id';
$title = get_string('additionalid', 'theme_universe');
$description = get_string('additionalid_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block7class';
$title = get_string('additionalclass', 'theme_universe');
$description = get_string('additionalclass_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block7introsubtitle';
$title = get_string('blockintrosubtitle', 'theme_universe');
$description = get_string('blockintrosubtitle_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block7introtitle';
$title = get_string('blockintrotitle', 'theme_universe');
$description = get_string('blockintrotitle_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block7introcontent';
$title = get_string('blockintrocontent', 'theme_universe');
$description = get_string('blockintrocontent_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block7htmlcontent';
$title = get_string('blockhtmlcontent', 'theme_universe');
$description = get_string('blockhtmlcontent_desc', 'theme_universe');
$default = '<div class="wrapper-md">
<!-- Start item -->
<div class="rui-card--colorized rui-rounded--lg" style="background-color: #fff3f7;">
<div class="d-flex flex-wrap align-content-center">
<div>
<h3 class="lead-1">universe for Moodle 4.x</h3>
<p class="text-size-xl text-secondary">For those who need customization....</p>
</div>

<div class="d-flex flex-wrap mt-4 row-cols-md-2">
<div>
<h4 class="text-primary">Pros</h4>
<ul class="list-styled col">
<li>Compatible with Moodle 4.1 and 4.0</li>
<li>22+ Fully Customizable Blocks</li>
<li>Lifetime updates</li>
<li>Super friendly support</li>
<li>Translation Ready</li>
</ul>
</div>
<div>
<h4 class="text-secondary">Cons</h4>
<ul class="list-styled col">
<li class="list-icon-x">Compatibility with older Moodle versions</li>
<li class="list-icon-x">Free Custom Work</li>
</ul>
</div>
</div>
<div class="my-4 w-100"><a href="#" class="btn btn-lg btn-primary">Lets get started</a>
</div>
<p class="text-size-sm">Learn more about customizing, pre-defined HTML blocks.
<a href="#" target="_blank" class="underline--anim">Go to the documentation page</a></p>
</div>
</div>
<!-- End item -->
</div>';
$setting = new universe_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block7footercontent';
$title = get_string('blockfootercontent', 'theme_universe');
$description = get_string('blockfootercontent_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block7customcss';
$title = get_string('blockcustomcss', 'theme_universe');
$description = get_string('blockcustomcss_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$settings->add($page);
