<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universe
 * @copyright 2021 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */


defined('MOODLE_INTERNAL') || die();

$page = new admin_settingpage('theme_universe_block3', get_string('settingsblock3', 'theme_universe'));

$name = 'theme_universe/displayblock3';
$title = get_string('turnon', 'theme_universe');
$description = get_string('displayblock3_desc', 'theme_universe');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title .
'<span class="badge badge-sq badge-dark ml-2">Block #3 (Hero Image)</span>', $description, $default);
$page->add($setting);

$name = 'theme_universe/block3fw';
$title = get_string('blockfw', 'theme_universe');
$description = get_string('blockfw_desc', 'theme_universe');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block3id';
$title = get_string('additionalid', 'theme_universe');
$description = get_string('additionalid_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block3class';
$title = get_string('additionalclass', 'theme_universe');
$description = get_string('additionalclass_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block3wrapperalign';
$title = get_string('block3wrapperalign', 'theme_universe');
$description = get_string('block3wrapperalign_desc', 'theme_universe');
$default = 1;
$choices = array(0 => 'Left', 1 => 'Middle', 2 => 'Right');
$setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
$page->add($setting);

$name = 'theme_universe/showblock3wrapper';
$title = get_string('showblock3wrapper', 'theme_universe');
$description = get_string('showblock3wrapper_desc', 'theme_universe');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block3wrapperbg';
$title = get_string('block3wrapperbg', 'theme_universe');
$description = get_string('block3wrapperbg_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/block3introcontent';
$title = get_string('blockintrocontent', 'theme_universe');
$description = get_string('blockintrocontent_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block3herosubtitle';
$title = get_string('blockintrosubtitle', 'theme_universe');
$description = get_string('blockintrosubtitle_desc', 'theme_universe');
$setting = new admin_setting_configtextarea($name, $title, $description, '', PARAM_TEXT);
$page->add($setting);

$name = 'theme_universe/block3herotitle';
$title = get_string('block3herotitle', 'theme_universe');
$description = get_string('block3herotitle_desc', 'theme_universe');
$setting = new admin_setting_configtextarea($name, $title, $description, '', PARAM_TEXT);
$page->add($setting);

$name = 'theme_universe/block3herotitlesize';
$title = get_string('blocktitlesize', 'theme_universe');
$description = get_string('blocktitlesize_desc', 'theme_universe');
$default = 1;
$choices = array(0 => 'Normal', 1 => 'Large', 2 => 'Extra Large');
$setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
$page->add($setting);

$name = 'theme_universe/block3herotitlecolor';
$title = get_string('blocktitlecolor', 'theme_universe');
$description = get_string('blocktitlecolor_desc', 'theme_universe');
$default = 1;
$choices = array(0 => 'White', 1 => 'Black', 2 => 'Gradient');
$setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
$page->add($setting);

$name = 'theme_universe/block3herotitleweight';
$title = get_string('blocktitleweight', 'theme_universe');
$description = get_string('blocktitleweight_desc', 'theme_universe');
$default = 1;
$choices = array(0 => 'Normal', 1 => 'Medium', 2 => 'Bold');
$setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
$page->add($setting);

$name = 'theme_universe/block3herocaption';
$title = get_string('block3herocaption', 'theme_universe');
$description = get_string('block3herocaption_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block3img';
$title = get_string('block3img', 'theme_universe');
$description = get_string('block3img_desc', 'theme_universe');
$opts = array('accepted_types' => array('.jpg, .png, .gif'), 'maxfiles' => 1);
$setting = new admin_setting_configstoredfile($name, $title, $description, 'block3img', 0, $opts);
$page->add($setting);

$name = 'theme_universe/block3htmlcontent';
$title = get_string('blockhtmlcontent', 'theme_universe');
$description = get_string('blockhtmlcontent_desc', 'theme_universe');
$default = '';
$setting = new universe_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block3footercontent';
$title = get_string('blockfootercontent', 'theme_universe');
$description = get_string('blockfootercontent_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$settings->add($page);
