<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universe
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */


defined('MOODLE_INTERNAL') || die();

$page = new admin_settingpage('theme_universe_block19', get_string('settingsblock19', 'theme_universe'));

$name = 'theme_universe/displayblock19';
$title = get_string('turnon', 'theme_universe');
$description = get_string('displayblock19_desc', 'theme_universe');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title .
'<span class="badge badge-sq badge-dark ml-2">Block #19</span>', $description, $default);
$page->add($setting);

$name = 'theme_universe/displayhrblock19';
$title = get_string('displayblockhr', 'theme_universe');
$description = get_string('displayblockhr_desc', 'theme_universe');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block19id';
$title = get_string('additionalid', 'theme_universe');
$description = get_string('additionalid_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block19class';
$title = get_string('additionalclass', 'theme_universe');
$description = get_string('additionalclass_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block19introsubtitle';
$title = get_string('blockintrosubtitle', 'theme_universe');
$description = get_string('blockintrosubtitle_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block19introtitle';
$title = get_string('blockintrotitle', 'theme_universe');
$description = get_string('blockintrotitle_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block19introcontent';
$title = get_string('blockintrocontent', 'theme_universe');
$description = get_string('blockintrocontent_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block19htmlcontent';
$title = get_string('blockhtmlcontent', 'theme_universe');
$description = get_string('blockhtmlcontent_desc', 'theme_universe');
$default = '<div class="rui-card-cat-grid">
<!-- Start item -->
<a href="#" class="rui-block-category-item">
<div class="rui-icon-box rui-icon-box--gray">
<img src="https://assets.rosea.io/universe/demo/icon.svg" alt="Icon #1" width="24" height="24" class="img-fluid">
</div>
<div class="ml-3">
<h3 class="rui-block-category-item-title">History</h3>
<span class="rui-block-category-item-subtitle">3 courses</span>
</div>
</a>
<!-- End item -->

<!-- Start item -->
<a href="#" class="rui-block-category-item">
<div class="rui-icon-box rui-icon-box--gray">
<img src="https://assets.rosea.io/universe/demo/icon.svg" alt="Icon #2" width="24" height="24" class="img-fluid">
</div>
<div class="ml-3">
<h3 class="rui-block-category-item-title">Statistics</h3>
<span class="rui-block-category-item-subtitle">16 courses</span>
</div>
</a>
<!-- End item -->

<!-- Start item -->
<a href="#" class="rui-block-category-item">
<div class="rui-icon-box rui-icon-box--gray">
<img src="https://assets.rosea.io/universe/demo/icon.svg" alt="Icon #3" width="24" height="24" class="img-fluid">
</div>
<div class="ml-3">
<h3 class="rui-block-category-item-title">Math</h3>
<span class="rui-block-category-item-subtitle">4 courses</span>
</div>
</a>
<!-- End item -->

<!-- Start item -->
<a href="#" class="rui-block-category-item">
<div class="rui-icon-box rui-icon-box--gray">
<img src="https://assets.rosea.io/universe/demo/icon.svg" alt="Icon #4" width="24" height="24" class="img-fluid">
</div>
<div class="ml-3">
<h3 class="rui-block-category-item-title">Geometry</h3>
<span class="rui-block-category-item-subtitle">9 courses</span>
</div>
</a>
<!-- End item -->

<!-- Start item -->
<a href="#" class="rui-block-category-item">
<div class="rui-icon-box rui-icon-box--gray">
<img src="https://assets.rosea.io/universe/demo/icon.svg" alt="Icon #5" width="24" height="24" class="img-fluid">
</div>
<div class="ml-3">
<h3 class="rui-block-category-item-title">Programming</h3>
<span class="rui-block-category-item-subtitle">2 courses</span>
</div>
</a>
<!-- End item -->

</div>';
$setting = new universe_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block19footercontent';
$title = get_string('blockfootercontent', 'theme_universe');
$description = get_string('blockfootercontent_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/block19customcss';
$title = get_string('blockcustomcss', 'theme_universe');
$description = get_string('blockcustomcss_desc', 'theme_universe');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$settings->add($page);
