<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universechild
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */


defined('MOODLE_INTERNAL') || die();

$page = new admin_settingpage('theme_universechild_customization', get_string('settingscustomization', 'theme_universechild'));
$name = 'theme_universechild/hgooglefont';
$heading = get_string('hgooglefont', 'theme_universechild');
$title = get_string('hgooglefont_desc', 'theme_universechild');
$setting = new admin_setting_heading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

// Google Font.
$name = 'theme_universechild/googlefonturl';
$title = get_string('googlefonturl', 'theme_universechild');
$description = get_string('googlefonturl_desc', 'theme_universechild');
$default = 'https://fonts.googleapis.com/css2?family=Manrope:wght@400,500,700&display=swap';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/fontheadings';
$title = get_string('fontheadings', 'theme_universechild');
$description = get_string('fontheadings_desc', 'theme_universechild');
$default = "'Manrope', Arial, sans-serif";
$setting = new admin_setting_configtext($name, $title, $description, $default);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/fontweightheadings';
$title = get_string('fontweightheadings', 'theme_universechild');
$description = get_string('fontweightheadings_desc', 'theme_universechild');
$default = '700';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/fontbody';
$title = get_string('fontbody', 'theme_universechild');
$description = get_string('fontbody_desc', 'theme_universechild');
$default = "'Manrope', Arial, sans-serif";
$setting = new admin_setting_configtext($name, $title, $description, $default);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/fontweightregular';
$title = get_string('fontweightregular', 'theme_universechild');
$description = get_string('fontweightregular_desc', 'theme_universechild');
$default = '400';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/fontweightmedium';
$title = get_string('fontweightmedium', 'theme_universechild');
$description = get_string('fontweightmedium_desc', 'theme_universechild');
$default = '500';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/fontweightbold';
$title = get_string('fontweightbold', 'theme_universechild');
$description = get_string('fontweightbold_desc', 'theme_universechild');
$default = '700';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/hgeneral';
$heading = get_string('hgeneral', 'theme_universechild');
$title = get_string('hgeneral_desc', 'theme_universechild');
$setting = new admin_setting_heading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universechild/colorbodybg';
$title = get_string('colorbodybg', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/colorborder';
$title = get_string('colorborder', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/btnborderradius';
$title = get_string('btnborderradius', 'theme_universechild');
$description = get_string('empty_desc', 'theme_universechild');
$setting = new admin_setting_configtext($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/hcolorstxt';
$heading = get_string('hcolorstxt', 'theme_universechild');
$title = get_string('hcolorstxt_desc', 'theme_universechild');
$setting = new admin_setting_heading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universechild/colorbody';
$title = get_string('colorbody', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/colorbodysecondary';
$title = get_string('colorbodysecondary', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/colorbodylight';
$title = get_string('colorbodylight', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/colorheadings';
$title = get_string('colorheadings', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/colorlink';
$title = get_string('colorlink', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/colorlinkhover';
$title = get_string('colorlinkhover', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/hcolorsprimary';
$heading = get_string('hcolorsprimary', 'theme_universechild');
$title = get_string('hcolorsprimary_desc', 'theme_universechild');
$setting = new admin_setting_heading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universechild/colorprimary600';
$title = get_string('colorprimary600', 'theme_universechild');
$description = get_string('colorprimary_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/colorprimary100';
$title = get_string('colorprimary100', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/colorprimary200';
$title = get_string('colorprimary200', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/colorprimary300';
$title = get_string('colorprimary300', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/colorprimary400';
$title = get_string('colorprimary400', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/colorprimary500';
$title = get_string('colorprimary500', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/colorprimary700';
$title = get_string('colorprimary700', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/colorprimary800';
$title = get_string('colorprimary800', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/colorprimary900';
$title = get_string('colorprimary900', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/hcolorsgrays';
$heading = get_string('hcolorsgrays', 'theme_universechild');
$title = get_string('hcolorsgrays_desc', 'theme_universechild');
$setting = new admin_setting_heading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universechild/colorgray100';
$title = get_string('colorgray100', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/colorgray200';
$title = get_string('colorgray200', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/colorgray300';
$title = get_string('colorgray300', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/colorgray400';
$title = get_string('colorgray400', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/colorgray500';
$title = get_string('colorgray500', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/colorgray600';
$title = get_string('colorgray600', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/colorgray700';
$title = get_string('colorgray700', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/colorgray800';
$title = get_string('colorgray800', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/colorgray900';
$title = get_string('colorgray900', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$settings->add($page);
