<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universechild
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */


defined('MOODLE_INTERNAL') || die();


$page = new admin_settingpage('theme_universechild_settingscourses', get_string( 'settingscourses', 'theme_universechild'));

// Show/hide course index navigation.
$name = 'theme_universechild/hidecourseindexnav';
$title = get_string('hidecourseindexnav', 'theme_universechild');
$description = get_string('hidecourseindexnav_desc', 'theme_universechild');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/courselistview';
$title = get_string('courselistview', 'theme_universechild');
$description = get_string('courselistview_desc', 'theme_universechild');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/cccteachers';
$title = get_string('cccteachers', 'theme_universechild');
$description = get_string('cccteachers_desc', 'theme_universechild');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

// Progress Bar.
$name = 'theme_universechild/courseprogressbar';
$title = get_string('courseprogressbar', 'theme_universechild');
$description = get_string('courseprogressbar_desc', 'theme_universechild', $a);
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/showcustomfields';
$title = get_string('showcustomfields', 'theme_universechild');
$description = get_string('showcustomfields_desc', 'theme_universechild');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/hactivityicons';
$heading = get_string('hactivityicons', 'theme_universechild');
$title = get_string('hactivityicons_desc', 'theme_universechild');
$setting = new admin_setting_heading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universechild/iconadministration';
$title = get_string('iconadministration', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/iconassessment';
$title = get_string('iconassessment', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/iconcolleboration';
$title = get_string('iconcolleboration', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/iconcommunication';
$title = get_string('iconcommunication', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/iconcontent';
$title = get_string('iconcontent', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/iconinterface';
$title = get_string('iconinterface', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/hcoursepagetabs';
$heading = get_string('hcoursepagetabs', 'theme_universechild');
$title = get_string('hcoursepagetabs_desc', 'theme_universechild');
$setting = new admin_setting_heading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universechild/coursetablayout';
$title = get_string('coursetablayout', 'theme_universechild');
$description = get_string('coursetablayout_desc', 'theme_universechild');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/istab2active';
$title = get_string('istab2active', 'theme_universechild');
$description = get_string('istab2active_desc', 'theme_universechild');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

// Course Tabs.
$name = 'theme_universechild/titlecoursetab1';
$title = get_string('titlecoursetab1', 'theme_universechild');
$description = get_string('titlecoursetab1_desc', 'theme_universechild');
$setting = new admin_setting_configtextarea($name, $title, $description, 'Overview');
$page->add($setting);

$name = 'theme_universechild/coursetab1content';
$title = get_string('blockhtmlcontent', 'theme_universechild');
$description = get_string('blockhtmlcontent_desc', 'theme_universechild');
$default = '';
$setting = new universechild_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/titlecoursetab2';
$title = get_string('titlecoursetab2', 'theme_universechild');
$description = get_string('titlecoursetab2_desc', 'theme_universechild');
$setting = new admin_setting_configtextarea($name, $title, $description, 'Course Content');
$page->add($setting);

$name = 'theme_universechild/coursetab2content';
$title = get_string('blockhtmlcontent', 'theme_universechild');
$description = get_string('blockhtmlcontent_desc', 'theme_universechild');
$default = '';
$setting = new universechild_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/titlecoursetab3';
$title = get_string('titlecoursetab3', 'theme_universechild');
$description = get_string('titlecoursetab3_desc', 'theme_universechild');
$setting = new admin_setting_configtextarea($name, $title, $description, 'FAQ');
$page->add($setting);

$name = 'theme_universechild/coursetab3content';
$title = get_string('blockhtmlcontent', 'theme_universechild');
$description = get_string('blockhtmlcontent_desc', 'theme_universechild');
$default = '';
$setting = new universechild_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/titlecoursetab4';
$title = get_string('titlecoursetab4', 'theme_universechild');
$description = get_string('titlecoursetab4_desc', 'theme_universechild');
$setting = new admin_setting_configtextarea($name, $title, $description, 'Resources');
$page->add($setting);

$name = 'theme_universechild/coursetab4content';
$title = get_string('blockhtmlcontent', 'theme_universechild');
$description = get_string('blockhtmlcontent_desc', 'theme_universechild');
$default = '';
$setting = new universechild_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/titlecoursetab5';
$title = get_string('titlecoursetab5', 'theme_universechild');
$description = get_string('titlecoursetab5_desc', 'theme_universechild');
$setting = new admin_setting_configtextarea($name, $title, $description, 'Teacher');
$page->add($setting);

$name = 'theme_universechild/coursetab5content';
$title = get_string('blockhtmlcontent', 'theme_universechild');
$description = get_string('blockhtmlcontent_desc', 'theme_universechild');
$default = '';
$setting = new universechild_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/cccteacherslist';
$title = get_string('cccteacherslist', 'theme_universechild');
$description = get_string('cccteacherslist_desc', 'theme_universechild');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/hcoursemainpage';
$heading = get_string('hcoursemainpage', 'theme_universechild');
$title = get_string('hcoursemainpage_desc', 'theme_universechild');
$setting = new admin_setting_heading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universechild/ipcoursesummary';
$title = get_string('ipcoursesummary', 'theme_universechild');
$description = get_string('ipcoursesummary_desc', 'theme_universechild');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/ipcoursedetails';
$title = get_string('ipcoursedetails', 'theme_universechild');
$description = get_string('ipcoursedetails_desc', 'theme_universechild');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/ipcourseimage';
$title = get_string('ipcourseimage', 'theme_universechild');
$description = get_string('ipcourseimage_desc', 'theme_universechild');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/coursedescwidth';
$title = get_string('coursedescwidth', 'theme_universechild');
$description = get_string('coursedescwidth_desc', 'theme_universechild');
$default = "700px";
$setting = new admin_setting_configtext($name, $title, $description, $default);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/incoursedescwidth';
$title = get_string('incoursedescwidth', 'theme_universechild');
$description = get_string('incoursedescwidth_desc', 'theme_universechild');
$default = "700px";
$setting = new admin_setting_configtext($name, $title, $description, $default);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/coursecoverstyle';
$title = get_string('coursecoverstyle', 'theme_universechild');
$description = get_string('coursecoverstyle_desc', 'theme_universechild');
$options = [];
$options['rui-course-cover--style-1'] = 'Style #1';
$options['rui-course-cover--style-2'] = 'Style #2';
$options['rui-course-cover--style-3'] = 'Style #3';
$setting = new admin_setting_configselect($name, $title, $description, 'rui-course-cover--style-1', $options);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/courselangbadge';
$title = get_string('courselangbadge', 'theme_universechild');
$description = get_string('courselangbadge_desc', 'theme_universechild', $a);
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/hcoursecard';
$heading = get_string('hcoursecard', 'theme_universechild');
$title = get_string('hcoursecard_desc', 'theme_universechild');
$setting = new admin_setting_heading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universechild/cccteacheravatar';
$title = get_string('cccteacheravatar', 'theme_universechild');
$description = get_string('cccteacheravatar_desc', 'theme_universechild');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/cccsummary';
$title = get_string('cccsummary', 'theme_universechild');
$description = get_string('cccsummary_desc', 'theme_universechild');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/coursecarddesclimit';
$title = get_string('coursecarddesclimit', 'theme_universechild');
$description = get_string('coursecarddesclimit_desc', 'theme_universechild');
$setting = new admin_setting_configtext($name, $title, $description, '100');
$page->add($setting);

$settings->add($page);
