<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Mustache helper to load a theme configuration.
 *
 * @package    theme_universechild
 * @copyright  Copyright © 2021 onwards, Marcin Czaja | RoseaThemes, rosea.io - Rosea Themes
 * @license    Commercial https://themeforest.net/licenses
 */

namespace theme_universechild\util;

use theme_config;
use stdClass;

/**
 * Helper to load a theme configuration.
 *
 * @package    theme_universechild
 * @copyright Copyright © 2018 onwards, Marcin Czaja | RoseaThemes, rosea.io - Rosea Themes
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class theme_settings {

    public function global_settings() {
        $theme = theme_config::load('universechild');

        $templatecontext = [];

        $elements = [
            'googlefonturl',
            'seothemecolor',
            'themeauthor',
            'displaycustomalert',
            'closecustomalert',
            'topbarlogoareaon',
            'customlogoandname',
            'fontawesome',
            'fontfiles',
            'customsignupoutside',
            'topbaradditionalbtn',
            'topbaradditionalbtnurl',
            'navbarlogobox',
            'coursecoverstyle',
            'istab2active'
        ];

        foreach ($elements as $setting) {
            if (!empty($theme->settings->$setting)) {
                $templatecontext[$setting] = $theme->settings->$setting;
            }
        }

        $elementshtml = [
            'stringmycourses',
            'seometadesc',
            'customalerthtml',
            'customstcontent',
            'customsmcontent',
            'customsfcontent',
            'customlogotxt',
            'topbarcustomhtml',
            'customnavitems',
            'sdarkmode',
            'slightmode',
            'stopbaradditionalbtn'
        ];

        foreach ($elementshtml as $setting) {
            if (!empty($theme->settings->$setting)) {
                $templatecontext[$setting] = format_text(($theme->settings->$setting), FORMAT_HTML, array('noclean' => true));
            }
        }

        if (!empty($theme->setting_file_url('customlogo', 'customlogo'))) {
            $templatecontext['customlogo'] = $theme->setting_file_url('customlogo', 'customlogo');
        }
        if (!empty($theme->setting_file_url('customdmlogo', 'customdmlogo'))) {
            $templatecontext['customdmlogo'] = $theme->setting_file_url('customdmlogo', 'customdmlogo');
        }
        if (!empty($theme->setting_file_url('customsidebarlogo', 'customsidebarlogo'))) {
            $templatecontext['customsidebarlogo'] = $theme->setting_file_url('customsidebarlogo', 'customsidebarlogo');
        }
        if (!empty($theme->setting_file_url('customsidebardmlogo', 'customsidebardmlogo'))) {
            $templatecontext['customsidebardmlogo'] = $theme->setting_file_url('customsidebardmlogo', 'customsidebardmlogo');
        }
        if (!empty($theme->setting_file_url('seomanifestjson', 'seomanifestjson'))) {
            $templatecontext['seomanifestjson'] = $theme->setting_file_url('seomanifestjson', 'seomanifestjson');
        }
        if (!empty($theme->setting_file_url('seoappletouchicon', 'seoappletouchicon'))) {
            $templatecontext['seoappletouchicon'] = $theme->setting_file_url('seoappletouchicon', 'seoappletouchicon');
        }

        return $templatecontext;
    }

    public function course_settings() {
        $theme = theme_config::load('universechild');

        $templatecontext = [];

        $elements = [
            'coursetablayout',
            'cccteacherslist'
        ];

        foreach ($elements as $setting) {
            if (!empty($theme->settings->$setting)) {
                $templatecontext[$setting] = $theme->settings->$setting;
            }
        }

        $elementshtml = [
            'titlecoursetab1',
            'titlecoursetab2',
            'titlecoursetab3',
            'titlecoursetab4',
            'titlecoursetab5',
            'coursetab1content',
            'coursetab2content',
            'coursetab3content',
            'coursetab4content',
            'coursetab5content'
        ];

        foreach ($elementshtml as $setting) {
            if (!empty($theme->settings->$setting)) {
                $templatecontext[$setting] = format_text(($theme->settings->$setting), FORMAT_HTML, array('noclean' => true));
            }
        }

        return $templatecontext;
    }

    public function footer_settings() {
        $theme = theme_config::load('universechild');

        $templatecontext = [];

        $elements = [
            'customalert',
            'darkmodetheme',
            'footercustomcss',
            'showfooterbuttons',
            'showbasicinfolist',
            'footerblock1hr',
            'footerblock2hr',
            'showsociallist',
            'facebook',
            'twitter',
            'linkedin',
            'youtube',
            'instagram',
            'mobile',
            'mail',
            'cwebsiteurl'
        ];

        foreach ($elements as $setting) {
            if (!empty($theme->settings->$setting)) {
                $templatecontext[$setting] = $theme->settings->$setting;
            }
        }

        $elementshtml = [
            'footerblock1',
            'footerblock2',
            'footerblock3',
            'footercopy',
            'block5slidesperrow',
            'customalertcontent',
            'website',
            'customsocialicon'
        ];

        foreach ($elementshtml as $setting) {
            if (!empty($theme->settings->$setting)) {
                $templatecontext[$setting] = format_text(($theme->settings->$setting), FORMAT_MOODLE);
            }
        }

        if (!empty($theme->setting_file_url('footerbgimg', 'footerbgimg'))) {
            $templatecontext['footerbgimg'] = $theme->setting_file_url('footerbgimg', 'footerbgimg');
        }

        return $templatecontext;
    }

    public function login_settings() {
        $theme = theme_config::load('universechild');

        $templatecontext = [];

        $elements = [
            'loginbg'
        ];

        foreach ($elements as $setting) {
            if (!empty($theme->setting_file_url($setting, $setting))) {
                $templatecontext[$setting] = $theme->setting_file_url($setting, $setting);
            }
        }

        return $templatecontext;
    }
}
