<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universechild
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */


defined('MOODLE_INTERNAL') || die();


$page = new admin_settingpage('theme_universechild_settingsfooter', get_string( 'settingsfooter', 'theme_universechild'));
$name = 'theme_universechild/showfooterbuttons';
$title = get_string('showfooterbuttons', 'theme_universechild');
$description = get_string('showfooterbuttons_desc', 'theme_universechild');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);


$name = 'theme_universechild/hfooterblocks';
$heading = get_string('hfooterblocks', 'theme_universechild');
$title = get_string('hfooterblocks_desc', 'theme_universechild');
$setting = new admin_setting_heading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universechild/footerblock1';
$title = get_string('footerblock1', 'theme_universechild');
$description = get_string('footerblock1_desc', 'theme_universechild');
$default = '<div class="row no-gutters text-sm-center text-md-left">
<div class="col-12 col-lg-5 pr-lg-5 mr-lg-5 my-sm-2 my-md-0">
<div class="d-flex justify-content-center justify-content-md-start">
<img src="https://assets.rosea.io/universechild/demo/universechild-logo-white.svg" width="66" height="40" class="img-fluid"/>
</div>
<h5 class="rui-footer-nav-title mt-3">universechild</h5>
<p class="text-size-xs">
Powerful, fully responsive, and easy-to-use Moodle Theme.
Works with Moodle 4.1, 4.0.<br>
<a href="#" target="_blank" title="Documentation - Footer Customization">Theme Documentation</a>
</p>
<p class="text-size-xs">
Made in Poland
</p>
</div>
<div class="col-12 col-lg my-sm-2 my-md-0">
<h5 class="rui-footer-nav-title">Course</h5>
<ul class="rui-footer-nav-items list-unstyled mb-0">
<li> <a href="#" target="_blank" title="Standard Course View">Standard Layout</a> </li>
<li> <a href="#" target="_blank" title="Tab Layout">Tab Layout</a>
<span class="badge-xs badge-primary ml-2">Demo</span> </li>
<li> <a href="#" target="_blank">Format Plugins</a> </li>
<li> <a href="#">Paid Course (PayPal, etc.)</a> </li>

</ul>
</div>
<div class="col-12 col-lg mt-sm-4 mt-lg-0">
<h5 class="rui-footer-nav-title">UI Elements</h5>
<ul class="rui-footer-nav-items list-unstyled mb-0">
<li> <a href="#">Front Page Blocks</a> </li>
<li> <a href="#">Blocks - Header</a> </li>
<li> <a href="#">Blocks - Footer</a> </li>
<li> <a href="#">Grid Content</a> </li>
<li> <a href="#">List</a> </li>
<li> <a href="#">Team</a> </li>
<li> <a href="#">Stats</a> </li>
<li> <a href="#">FAQ</a> </li>
</ul>
</div>
<div class="col-12 col-lg mt-sm-4 mt-lg-0">
<h5 class="rui-footer-nav-title">More</h5>
<ul class="rui-footer-nav-items list-unstyled mb-0">
<li> <a href="#">Icons</a> </li>
<li> <a href="#">Plugins support</a> </li>
<li> <a href="https://rosea.gitbook.io/universechild/" target="_blank" title="Theme Doc">Theme Doc</a> </li>
</ul>
</div>
</div>
<br />To edit this block go to: Site administration - Appearance - universechild - Footer - Footer Block #1';
$setting = new universechild_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/footerblock1hr';
$title = get_string('footerblock1hr', 'theme_universechild');
$description = get_string('footerblock1hr_desc', 'theme_universechild');
$default = '1';
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/footerblock2';
$title = get_string('footerblock2', 'theme_universechild');
$description = get_string('footerblock2_desc', 'theme_universechild');
$default = '';
$setting = new universechild_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/footerblock2hr';
$title = get_string('footerblock2hr', 'theme_universechild');
$description = get_string('footerblock2hr_desc', 'theme_universechild');
$default = '1';
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/footerblock3';
$title = get_string('footerblock3', 'theme_universechild');
$description = get_string('footerblock3_desc', 'theme_universechild');
$default = 'To edit this block go to: Site administration - Appearance - universechild - Footer - Footer Block #3
<small>Get this theme exclusively on ThemeForest. Check all available Moodle themes
<a href="https://rosea.io" class="underline--anim">rosea.io</a></small>';
$setting = new universechild_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/footercopy';
$title = get_string('footercopy', 'theme_universechild');
$description = get_string('footercopy_desc', 'theme_universechild');
$default = '© <strong>2023</strong>
<br />To edit this block go to: Site administration - Appearance - universechild - Footer - Footer Copy';
$setting = new universechild_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/hfootercolors';
$heading = get_string('hfootercolors', 'theme_universechild');
$title = get_string('hfootercolors_desc', 'theme_universechild');
$setting = new admin_setting_heading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universechild/colorfooterbg';
$title = get_string('colorfooterbg', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/colorfooterborder';
$title = get_string('colorfooterborder', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/colorfootertext';
$title = get_string('colorfootertext', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/colorfooterlink';
$title = get_string('colorfooterlink', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/colorfooterlinkhover';
$title = get_string('colorfooterlinkhover', 'theme_universechild');
$description = get_string('color_desc', 'theme_universechild');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$fileid = 'footerbgimg';
$name = 'theme_universechild/footerbgimg';
$title = get_string('footerbgimg', 'theme_universechild');
$description = get_string('footerbgimg_desc', 'theme_universechild');
$opts = array('accepted_types' => array('.png', '.jpg', '.gif', '.webp', '.tiff', '.svg'), 'maxfiles' => 1);
$setting = new admin_setting_configstoredfile($name, $title, $description, $fileid, 0, $opts);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universechild/footercustomcss';
$title = get_string('footercustomcss', 'theme_universechild');
$description = get_string('blockcustomcss_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);


$name = 'theme_universechild/hfootersocial';
$heading = get_string('hfootersocial', 'theme_universechild');
$title = get_string('hfootersocial_desc', 'theme_universechild');
$setting = new admin_setting_heading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universechild/showbasicinfolist';
$title = get_string('showbasicinfolist', 'theme_universechild');
$description = get_string('showbasicinfolist_desc', 'theme_universechild');
$default = '0';
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

// Website.
$name = 'theme_universechild/website';
$title = get_string('website', 'theme_universechild');
$description = get_string('website_desc', 'theme_universechild');
$default = 'Moodle Themes';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

// Website.
$name = 'theme_universechild/cwebsiteurl';
$title = get_string('cwebsiteurl', 'theme_universechild');
$description = get_string('cwebsiteurl_desc', 'theme_universechild');
$default = 'https://rosea.io';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

// Mobile.
$name = 'theme_universechild/mobile';
$title = get_string('mobile', 'theme_universechild');
$description = get_string('mobile_desc', 'theme_universechild');
$default = 'Mobile : +12 (34) 00123-45678';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

// Mail.
$name = 'theme_universechild/mail';
$title = get_string('mail', 'theme_universechild');
$description = get_string('mail_desc', 'theme_universechild');
$default = 'sample@mail.com';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universechild/showsociallist';
$title = get_string('showsociallist', 'theme_universechild');
$description = get_string('showsociallist_desc', 'theme_universechild');
$default = '0';
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

// Facebook url setting.
$name = 'theme_universechild/facebook';
$title = get_string('facebook', 'theme_universechild');
$description = get_string('facebook_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

// Twitter url setting.
$name = 'theme_universechild/twitter';
$title = get_string('twitter', 'theme_universechild');
$description = get_string('twitter_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

// Linkdin url setting.
$name = 'theme_universechild/linkedin';
$title = get_string('linkedin', 'theme_universechild');
$description = get_string('linkedin_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

// Youtube url setting.
$name = 'theme_universechild/youtube';
$title = get_string('youtube', 'theme_universechild');
$description = get_string('youtube_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

// Instagram url setting.
$name = 'theme_universechild/instagram';
$title = get_string('instagram', 'theme_universechild');
$description = get_string('instagram_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtext($name, $title, $description, $default);
$page->add($setting);

// Cutsom icons setting.
$name = 'theme_universechild/customsocialicon';
$title = get_string('customsocialicon', 'theme_universechild');
$description = get_string('customsocialicon_desc', 'theme_universechild');
$default = '';
$setting = new admin_setting_configtextarea($name, $title, $description, $default);
$page->add($setting);

// Must add the page after definiting all the settings!
$settings->add($page);
