<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universechild
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */

defined('MOODLE_INTERNAL') || die();
global $PAGE, $OUTPUT;

// Variables - Settings.
$block4introsubtitle = format_text(theme_universechild_get_setting('block4introsubtitle'), FORMAT_HTML, array('noclean' => true));
$block4wrapperalign = theme_universechild_get_setting('block4wrapperalign');
$block4titlecolor = theme_universechild_get_setting('block4herotitlecolor');
$block4herotitlesize = theme_universechild_get_setting('block4herotitlesize');
$block4titleweight = theme_universechild_get_setting('block4herotitleweight');
$block4count = theme_universechild_get_setting('block4count');
$block4class = theme_universechild_get_setting('block4class');

if (!empty(theme_universechild_get_setting('block4sliderinterval'))) {
    $block4sliderinterval = theme_universechild_get_setting('block4sliderinterval');
} else {
    $block4sliderinterval = '7000';
}

// Customm ID for the block.
$block4customid = theme_universechild_get_setting('block4id');
$fpblockid4 = 'block4';
if (!empty($block4customid)) {
    $fpblockid5 = $block4customid;
}
// End.

// Start Title - Alignment.
$block4wrapperalignclass = null;
if ($block4wrapperalign == 0) {
    $block4wrapperalignclass = 'rui-hero-content-left';
}

if ($block4wrapperalign == 1) {
    $block4wrapperalignclass = 'rui-hero-content-centered';
}

if ($block4wrapperalign == 2) {
    $block4wrapperalignclass = 'rui-hero-content-right';
}
// End.

// Start Title - Color.
$block4titlecolorclass = null;
if ($block4titlecolor == 0) {
    $block4titlecolorclass = ' rui-text--white';
}

if ($block4titlecolor == 1) {
    $block4titlecolorclass = ' rui-text--black';
}

if ($block4titlecolor == 2) {
    $block4titlecolorclass = ' rui-text--gradient';
}
// End.

// Start Title - Weight.
$block4titleweightclass = null;
if ($block4titleweight == 0) {
    $block4titleweightclass = ' rui-text--weight-normal';
}

if ($block4titleweight == 1) {
    $block4titleweightclass = ' rui-text--weight-medium';
}

if ($block4titleweight == 2) {
    $block4titleweightclass = ' rui-text--weight-bold';
}
// End.

// Start Title - Size.
$block4herotitlesizeclass = null;
if ($block4herotitlesize == 0) {
    $block4herotitlesizeclass = '';
}

if ($block4herotitlesize == 1) {
    $block4herotitlesizeclass = ' rui-hero-title-lg';
}

if ($block4herotitlesize == 2) {
    $block4herotitlesizeclass = ' rui-hero-title-xl';
}
// End.

if (theme_universechild_get_setting('showblock4sliderwrapper') == '1') {
    $class = 'rui-hero-content-backdrop rui-hero-content-backdrop--block4';
} else {
    $class = '';
}

echo '<!-- Start Block #1 -->';

if (theme_universechild_get_setting('block4fw') == '1') {
    echo '<div id="' . $fpblockid4 . '" class="wrapper-fw rui-fp-block--4 rui-fp-margin-bottom ' . $block4class . '">';
} else {
    echo '<div id="' . $fpblockid4 . '" class="wrapper-lg rui-fp-block--4 rui-fp-margin-bottom mt-3 ' . $block4class . '">';
}


echo '<div class="swiper swiper-block--4 pb-0">';
echo '<div class="swiper-wrapper">';

for ($i = 1; $i <= $block4count; $i++) {

    $title = format_text(theme_universechild_get_setting("block4slidetitle" . $i), FORMAT_HTML, array('noclean' => true));
    $caption = format_text(theme_universechild_get_setting("block4slidecaption" . $i), FORMAT_HTML, array('noclean' => true));
    $css = theme_universechild_get_setting("block4slidecss" . $i);
    $img = $PAGE->theme->setting_file_url("block4slideimg" . $i, "block4slideimg" . $i);

    if (!empty($css)) {
        echo '<div class="rui-hero-bg swiper-slide">';
    } else {
        echo '<div class="rui-hero-bg swiper-slide" style="' . $css . '">';
    }

    if (!empty($caption) || !empty($title)) {
        echo '<div class="rui-hero-content rui-hero--slide ' .
        $class .
        ' rui-hero-content-position ' .
        $block4wrapperalignclass .
        '">';
    }

    if (!empty($title)) {
        echo '<h3 class="rui-hero-title' .
            $block4titlecolorclass .
            $block4titleweightclass .
            $block4herotitlesizeclass .
            '">' . $title . '</h3>';
    }

    if (!empty($caption)) {
        echo '<div class="rui-hero-desc">' . $caption . '</div>';
    }

    if (!empty($caption) || !empty($title)) {
        echo '</div>';
    }

    echo '<img class="d-flex img-fluid w-100" src="' . $img . '" alt="' . $title . '" />';
    echo '</div>';
}

echo '</div>';
echo '<div class="d-none d-md-flex swiper-button-next"></div>';
echo '<div class="d-none d-md-flex swiper-button-prev"></div>';
echo '<div class="swiper-pagination"></div>';
echo '</div>';
echo '</div>';

/*
    function reportWindowSize() {
        // Align center content of the hero
        var el = document.getElementsByClassName("rui-hero-content");
        for (var i=0, len=el.length|0; i<len; i=i+1|0) {
            var sidebarContentHeight = el[i].offsetHeight;
            el[i].style.top = "calc(50% - " + sidebarContentHeight * 0.5+ "px)";
        }
    }

    window.addEventListener("resize", reportWindowSize);
    window.onload = reportWindowSize();
*/
echo '<script>function reportWindowSize(){for(var e=document.getElementsByClassName("rui-hero--slide"),
o=0,t=0|e.length;o<t;o=o+1|0){var n=e[o].offsetHeight;e[o].style.top="calc(50% - "+n/2+"px)"}}
window.addEventListener("resize",reportWindowSize),
window.onload=reportWindowSize();</script>';
echo '<!-- End Block #1 -->';

echo '<script>var swiper=new Swiper(".swiper-block--4",{slidesPerView:1,
pagination:{el:".swiper-pagination",type:"progressbar"},
navigation:{nextEl:".swiper-button-next",prevEl:".swiper-button-prev"},
autoplay: {delay: ' . $block4sliderinterval . ',},
keyboard:{enabled:!0},mousewheel:{releaseOnEdges:!0},effect:"creative",
autoHeight:!0,creativeEffect:{prev:{shadow:!0,translate:["-20%",0,-1]},
next:{translate:["100%",0,0]}},breakpoints:{}});</script>';
