<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * universechild config.
 *
 * @package   theme_universechild
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 */

defined('MOODLE_INTERNAL') || die();

require_once(__DIR__ . '/lib.php');

$THEME->name = 'universechild';
$THEME->sheets = [];
$THEME->editor_sheets = [];
$THEME->editor_scss = ['editor'];
$THEME->usefallback = true;
$THEME->scss = function($theme) {
    return theme_universechild_get_main_scss_content($theme);
};

$THEME->layouts = [
    // Server administration scripts.
    'admin' => array(
        'file' => 'tmpl-admin.php',
        'regions' => array(
            'side-pre',
            'sidebartb',
            'sidebarbb',
            'sidecourseblocks'
        ),
        'defaultregion' => 'side-pre',
    )
];

$THEME->parents = ['universe'];
$THEME->enable_dock = false;
$THEME->extrascsscallback = 'theme_universechild_get_extra_scss';
$THEME->prescsscallback = 'theme_universechild_get_pre_scss';
$THEME->precompiledcsscallback = 'theme_universechild_get_precompiled_css';
$THEME->yuicssmodules = array();
$THEME->rendererfactory = 'theme_overridden_renderer_factory';
$THEME->requiredblocks = '';
$THEME->addblockposition = BLOCK_ADDBLOCK_POSITION_FLATNAV;
$THEME->haseditswitch = true;
$THEME->iconsystem = \core\output\icon_system::STANDARD;
if ($THEME->settings->hidecourseindexnav == 0) {
    $THEME->usescourseindex = true;
} else {
    $THEME->usescourseindex = false;
}
$THEME->removedprimarynavitems = explode(',', get_config('theme_universechild', 'hidenodesprimarynavigation'));
// By default, all boost theme do not need their titles displayed.
$THEME->activityheaderconfig = [
    'notitle' => true
];
