<?php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, DELETE, PUT, PATCH, OPTIONS');
header('Access-Control-Allow-Headers: token, Content-Type');
header('Access-Control-Max-Age: 1728000');
header('Content-Type: application/json');


require_once(__DIR__ . '/config.php');
require_once(__DIR__ . '/../config.php');
require_once(__DIR__ . '/rsa.php');
require_once(__DIR__ . '/lib.php');

global $DB, $CFG;

require_once($CFG->libdir.'/moodlelib.php');
require_once($CFG->libdir . '/externallib.php');
require_once($CFG->libdir.'/authlib.php');
require_once( $CFG->libdir . '/gdlib.php' );

require_once($CFG->dirroot.'/user/lib.php');


$username   = trim(isset($_POST['username']) ? filter_var($_POST['username'], FILTER_SANITIZE_STRING) : '');
$password   = trim(isset($_POST['password']) ? filter_var($_POST['password'], FILTER_SANITIZE_STRING) : '');
$timestamp  = trim(isset($_POST['timestamp']) ? filter_var($_POST['timestamp'], FILTER_SANITIZE_STRING) : '');
$rand       = intval(isset($_POST['rand']) ? filter_var($_POST['rand'], FILTER_SANITIZE_NUMBER_INT) : 0,10);
$data       = trim(isset($_POST['data']) ? filter_var($_POST['data'], FILTER_SANITIZE_STRING) : '');


if(empty($username) || empty($password) || empty($timestamp) || empty($rand) || !is_integer($rand)) {
    echo json_encode(['success' => false, 'data' => 'ERROR_SECURITY1']) ;
    exit;
}

if($username != LLWS_USERNAME) {
    echo json_encode(['success' => false, 'data' => 'ERROR_SECURITY2']) ;
    exit;
}

$dt = \DateTimeImmutable::createFromFormat('Y-m-d\TH:i:s',  gmdate('Y-m-d\TH:i:s'));
$dtMax = $dt->add(\DateInterval::createFromDateString('5 minutes'));
$dtMin = $dt->sub(\DateInterval::createFromDateString('5 minutes'));


$t0 = $dt->getTimestamp();
$t1 = $dtMin->getTimestamp();
$t2 = $dtMax->getTimestamp();

if($t0 < $t1 || $t0 > $t2) {
    echo json_encode(['success' => false, 'data' => 'ERROR_SECURITY4']) ;
    exit;
}

if(!password_verify( $username.'-'. LLWS_PASSWORD. '-' . $rand. '-' . $timestamp, $password)) {
    echo json_encode(['success' => false, 'data' => 'ERROR_SECURITY5']) ;
    exit;
}

if(empty($data)) {
    echo json_encode(['success' => false, 'data' => 'ERROR_PARAMETERS1']) ;
    exit;
}

$data = base64_decode($data);
if(empty($data)) {
    echo json_encode(['success' => false, 'data' => 'ERROR_PARAMETERS2']) ;
    exit;
}

try {
    $rsa = new rsa();
    $rsa->setKeys(LLWS_RSA_N, LLWS_RSA_D, LLWS_RSA_E);
    $data = $rsa->decrypt($data);
} catch (Throwable $e)
{
    echo json_encode(['success' => false, 'data' => 'ERROR_PARAMETERS3']) ;
    exit;
}
 
$data = (array) json_decode($data);
if(empty($data)) {
    echo json_encode(['success' => false, 'data' => 'ERROR_PARAMETERS4']) ;
    exit;
}


$email      = trim(isset($data['email']) ? filter_var($data['email'], FILTER_SANITIZE_EMAIL) : '');
$first_name = trim(isset($data['first_name']) ? filter_var($data['first_name'], FILTER_SANITIZE_STRING) : '');
$last_name  = trim(isset($data['last_name']) ? filter_var($data['last_name'], FILTER_SANITIZE_STRING) : '');
$password   = trim(isset($data['password']) ? filter_var($data['password'], FILTER_SANITIZE_STRING) : '');

if(!filter_var($email, FILTER_VALIDATE_EMAIL) || empty($first_name) || empty($last_name)) {
    echo json_encode(['success' => false, 'data' => 'ERROR_PARAMETERS5']) ;
    exit;
}

$user = ll_get_user_by_email($email);
if($user) {
    $new_user = false;
} else {
    $new_user = true;
    $username = ll_get_username_available($first_name, $last_name);

    $user = ll_create_user($username, $email, $first_name, $last_name);
    
}



if(!$user) {
    echo json_encode(['success' => false, 'data' => 'ERROR_MOODLE1']) ;
    exit;
}      

if($new_user) {
    $role = $DB->get_record('role', array('archetype' => 'student'));
    $enrolmethod = 'manual';
    
    $courses = get_courses();
    foreach($courses as $course)
    {
        if($course->categoy_id == LLWS_CATEGORY_ID) {
            $context = context_course::instance($course->id);
            if (!is_enrolled($context, $user)) {
                $enrol = enrol_get_plugin($enrolmethod);
                if ($enrol === null) {
                    return false;
                }
                $instances = enrol_get_instances($course->id, true);
                $manualinstance = null;
                foreach ($instances as $instance) {
                    if ($instance->name == $enrolmethod) {
                        $manualinstance = $instance;
                        break;
                    }
                }
                if ($manualinstance !== null) {
                    $instanceid = $enrol->add_default_instance($course);
                    if ($instanceid === null) {
                        $instanceid = $enrol->add_instance($course);
                    }
                    $instance = $DB->get_record('enrol', array('id' => $instanceid));
                    if($instance) {
                        $enrol->enrol_user($instance, $user->id, $role->id);
                    }
                }
                
            }
        }
    }
    
}




$user = get_complete_user_data('id', $user->id);
if (!isloggedin()) {
    complete_user_login($user);
}

header('Location: '. $CFG->wwwroot . '/my');
exit;

