<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * @package   theme_universe
 * @copyright 2023 Marcin Czaja (https://rosea.io)
 * @license   Commercial https://themeforest.net/licenses
 *
 */


defined('MOODLE_INTERNAL') || die();


$page = new admin_settingpage('theme_universe_settingscourses', get_string( 'settingscourses', 'theme_universe'));

// Show/hide course index navigation.
$name = 'theme_universe/hidecourseindexnav';
$title = get_string('hidecourseindexnav', 'theme_universe');
$description = get_string('hidecourseindexnav_desc', 'theme_universe');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/courselistview';
$title = get_string('courselistview', 'theme_universe');
$description = get_string('courselistview_desc', 'theme_universe');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/cccteachers';
$title = get_string('cccteachers', 'theme_universe');
$description = get_string('cccteachers_desc', 'theme_universe');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

// Progress Bar.
$name = 'theme_universe/courseprogressbar';
$title = get_string('courseprogressbar', 'theme_universe');
$description = get_string('courseprogressbar_desc', 'theme_universe', $a);
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/showcustomfields';
$title = get_string('showcustomfields', 'theme_universe');
$description = get_string('showcustomfields_desc', 'theme_universe');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/hactivityicons';
$heading = get_string('hactivityicons', 'theme_universe');
$title = get_string('hactivityicons_desc', 'theme_universe');
$setting = new admin_setting_heading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universe/iconadministration';
$title = get_string('iconadministration', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/iconassessment';
$title = get_string('iconassessment', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/iconcolleboration';
$title = get_string('iconcolleboration', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/iconcommunication';
$title = get_string('iconcommunication', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/iconcontent';
$title = get_string('iconcontent', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/iconinterface';
$title = get_string('iconinterface', 'theme_universe');
$description = get_string('color_desc', 'theme_universe');
$setting = new admin_setting_configcolourpicker($name, $title, $description, '');
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/hcoursepagetabs';
$heading = get_string('hcoursepagetabs', 'theme_universe');
$title = get_string('hcoursepagetabs_desc', 'theme_universe');
$setting = new admin_setting_heading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universe/coursetablayout';
$title = get_string('coursetablayout', 'theme_universe');
$description = get_string('coursetablayout_desc', 'theme_universe');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/istab2active';
$title = get_string('istab2active', 'theme_universe');
$description = get_string('istab2active_desc', 'theme_universe');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

// Course Tabs.
$name = 'theme_universe/titlecoursetab1';
$title = get_string('titlecoursetab1', 'theme_universe');
$description = get_string('titlecoursetab1_desc', 'theme_universe');
$setting = new admin_setting_configtextarea($name, $title, $description, 'Overview');
$page->add($setting);

$name = 'theme_universe/coursetab1content';
$title = get_string('blockhtmlcontent', 'theme_universe');
$description = get_string('blockhtmlcontent_desc', 'theme_universe');
$default = '';
$setting = new universe_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/titlecoursetab2';
$title = get_string('titlecoursetab2', 'theme_universe');
$description = get_string('titlecoursetab2_desc', 'theme_universe');
$setting = new admin_setting_configtextarea($name, $title, $description, 'Course Content');
$page->add($setting);

$name = 'theme_universe/coursetab2content';
$title = get_string('blockhtmlcontent', 'theme_universe');
$description = get_string('blockhtmlcontent_desc', 'theme_universe');
$default = '';
$setting = new universe_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/titlecoursetab3';
$title = get_string('titlecoursetab3', 'theme_universe');
$description = get_string('titlecoursetab3_desc', 'theme_universe');
$setting = new admin_setting_configtextarea($name, $title, $description, 'FAQ');
$page->add($setting);

$name = 'theme_universe/coursetab3content';
$title = get_string('blockhtmlcontent', 'theme_universe');
$description = get_string('blockhtmlcontent_desc', 'theme_universe');
$default = '';
$setting = new universe_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/titlecoursetab4';
$title = get_string('titlecoursetab4', 'theme_universe');
$description = get_string('titlecoursetab4_desc', 'theme_universe');
$setting = new admin_setting_configtextarea($name, $title, $description, 'Resources');
$page->add($setting);

$name = 'theme_universe/coursetab4content';
$title = get_string('blockhtmlcontent', 'theme_universe');
$description = get_string('blockhtmlcontent_desc', 'theme_universe');
$default = '';
$setting = new universe_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/titlecoursetab5';
$title = get_string('titlecoursetab5', 'theme_universe');
$description = get_string('titlecoursetab5_desc', 'theme_universe');
$setting = new admin_setting_configtextarea($name, $title, $description, 'Teacher');
$page->add($setting);

$name = 'theme_universe/coursetab5content';
$title = get_string('blockhtmlcontent', 'theme_universe');
$description = get_string('blockhtmlcontent_desc', 'theme_universe');
$default = '';
$setting = new universe_setting_confightmleditor($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/cccteacherslist';
$title = get_string('cccteacherslist', 'theme_universe');
$description = get_string('cccteacherslist_desc', 'theme_universe');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/hcoursemainpage';
$heading = get_string('hcoursemainpage', 'theme_universe');
$title = get_string('hcoursemainpage_desc', 'theme_universe');
$setting = new admin_setting_heading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universe/ipcoursesummary';
$title = get_string('ipcoursesummary', 'theme_universe');
$description = get_string('ipcoursesummary_desc', 'theme_universe');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/ipcoursedetails';
$title = get_string('ipcoursedetails', 'theme_universe');
$description = get_string('ipcoursedetails_desc', 'theme_universe');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/ipcourseimage';
$title = get_string('ipcourseimage', 'theme_universe');
$description = get_string('ipcourseimage_desc', 'theme_universe');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/courseimagefw';
$title = get_string('courseimagefw', 'theme_universe');
$description = get_string('courseimagefw_desc', 'theme_universe');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

// $name = 'theme_universe/coursedescwidth';
// $title = get_string('coursedescwidth', 'theme_universe');
// $description = get_string('coursedescwidth_desc', 'theme_universe');
// $default = "700px";
// $setting = new admin_setting_configtext($name, $title, $description, $default);
// $setting->set_updatedcallback('theme_reset_all_caches');
// $page->add($setting);

// $name = 'theme_universe/incoursedescwidth';
// $title = get_string('incoursedescwidth', 'theme_universe');
// $description = get_string('incoursedescwidth_desc', 'theme_universe');
// $default = "700px";
// $setting = new admin_setting_configtext($name, $title, $description, $default);
// $setting->set_updatedcallback('theme_reset_all_caches');
// $page->add($setting);

$name = 'theme_universe/coursecoverstyle';
$title = get_string('coursecoverstyle', 'theme_universe');
$description = get_string('coursecoverstyle_desc', 'theme_universe');
$options = [];
$options['rui-course-cover--style-1'] = 'Style #1';
$options['rui-course-cover--style-2'] = 'Style #2';
$options['rui-course-cover--style-3'] = 'Style #3';
$setting = new admin_setting_configselect($name, $title, $description, 'rui-course-cover--style-1', $options);
$setting->set_updatedcallback('theme_reset_all_caches');
$page->add($setting);

$name = 'theme_universe/courselangbadge';
$title = get_string('courselangbadge', 'theme_universe');
$description = get_string('courselangbadge_desc', 'theme_universe', $a);
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/hcoursecard';
$heading = get_string('hcoursecard', 'theme_universe');
$title = get_string('hcoursecard_desc', 'theme_universe');
$setting = new admin_setting_heading($name, $heading, format_text($title, FORMAT_MARKDOWN));
$page->add($setting);

$name = 'theme_universe/cccteacheravatar';
$title = get_string('cccteacheravatar', 'theme_universe');
$description = get_string('cccteacheravatar_desc', 'theme_universe');
$default = 0;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/cccsummary';
$title = get_string('cccsummary', 'theme_universe');
$description = get_string('cccsummary_desc', 'theme_universe');
$default = 1;
$setting = new admin_setting_configcheckbox($name, $title, $description, $default);
$page->add($setting);

$name = 'theme_universe/coursecarddesclimit';
$title = get_string('coursecarddesclimit', 'theme_universe');
$description = get_string('coursecarddesclimit_desc', 'theme_universe');
$setting = new admin_setting_configtext($name, $title, $description, '100');
$page->add($setting);

$settings->add($page);
