<?php
defined('MOODLE_INTERNAL') || die();

// Incluir el archivo lib.php del tema padre
require_once($CFG->dirroot . '/theme/universe/lib.php');

function theme_universe_child_themedir()
{
    global $CFG;

    $teme_dir = '/theme';

    if (isset($CFG->themedir)) {
        $teme_dir = $CFG->themedir;
        $teme_dir = str_replace($CFG->dirroot, '', $CFG->themedir);
    }

    return $teme_dir;
}

function theme_universe_child_get_setting($setting, $format = false)
{
    $theme = theme_config::load('universe');

    if (empty($theme->settings->$setting)) {
        return false;
    }

    if (!$format) {
        return $theme->settings->$setting;
    }

    if ($format === 'format_text') {
        return format_text($theme->settings->$setting, FORMAT_PLAIN);
    }

    if ($format === 'format_html') {
        return format_text($theme->settings->$setting, FORMAT_HTML, array('trusted' => true, 'noclean' => true));
    }

    return format_string($theme->settings->$setting);
}

function theme_universe_child_get_pre_scss($theme)
{
    // Load the settings from the parent.                                                                                           
    $theme = theme_config::load('universe');
    // Call the parent themes get_pre_scss function.                                                                                
    return theme_universe_get_pre_scss($theme);
}

function theme_universe_child_get_main_scss_content($theme)
{
    global $CFG;
    return theme_universe_get_main_scss_content($theme);
}

/**
 * Obtiene la pista de acceso para invitados al curso
 * @param int $courseid ID del curso
 * @return string HTML con la pista de acceso
 */
function theme_universe_child_get_course_guest_access_hint($courseid)
{
    global $CFG;
    require_once($CFG->dirroot . '/enrol/self/lib.php');

    $html = '';
    $instances = enrol_get_instances($courseid, true);
    $plugins = enrol_get_plugins(true);
    foreach ($instances as $instance) {
        if (!isset($plugins[$instance->enrol])) {
            continue;
        }
        $plugin = $plugins[$instance->enrol];
        if ($plugin->show_enrolme_link($instance)) {
            $html = html_writer::tag('div', get_string(
                'showhintcourseguestaccesslink',
                'theme_universe_child',
                array('url' => $CFG->wwwroot . '/enrol/index.php?id=' . $courseid)
            ));
            break;
        }
    }

    return $html;
}

/**
 * Obtiene los banners de información del curso
 * @return string HTML con los banners de información
 */
function theme_universe_child_get_course_information_banners()
{
    global $CFG, $COURSE, $PAGE, $USER, $OUTPUT;

    // Require user library.
    require_once($CFG->dirroot . '/user/lib.php');

    // Initialize HTML code.
    $html = '';

    // Check if user is admin, teacher or editing teacher.
    if (
        user_has_role_assignment($USER->id, '1') ||
        user_has_role_assignment($USER->id, '2') ||
        user_has_role_assignment($USER->id, '3') ||
        user_has_role_assignment($USER->id, '4')
    ) {
        $allowtoshowhint = true;
    } else {
        $allowtoshowhint = false;
    }

    // Verificar acceso de invitados
    if (
        get_config('theme_universe_child', 'showhintcourseguestaccess') == 1
        && is_guest(\context_course::instance($COURSE->id), $USER->id)
        && $PAGE->has_set_url()
        && $PAGE->url->compare(new moodle_url('/course/view.php'), URL_MATCH_BASE)
        && !is_role_switched($COURSE->id)
    ) {
        // Require self enrolment library.
        require_once($CFG->dirroot . '/enrol/self/lib.php');

        // Prepare template context.
        $templatecontext = array(
            'courseid' => $COURSE->id,
            'role' => role_get_name(get_guest_role())
        );

        // Search for an available self enrolment link in this course.
        $templatecontext['showselfenrollink'] = false;
        $instances = enrol_get_instances($COURSE->id, true);
        $plugins = enrol_get_plugins(true);
        foreach ($instances as $instance) {
            if (!isset($plugins[$instance->enrol])) {
                continue;
            }
            $plugin = $plugins[$instance->enrol];
            if ($plugin->show_enrolme_link($instance)) {
                $templatecontext['showselfenrollink'] = true;
                break;
            }
        }

        // Render template and add it to HTML code.
        $html .= $OUTPUT->render_from_template('theme_universe_child/course-hint-guestaccess', $templatecontext);
    }

    return $html;
}

/**
 * Verifica si el usuario es invitado en el contexto del curso
 * @param context_course $context Contexto del curso
 * @param int $userid ID del usuario
 * @return bool True si el usuario es invitado
 */
function theme_universe_child_is_guest_in_course($context, $userid)
{
    return is_guest($context, $userid);
}

/**
 * Get all parent theme settings
 * @return array Array of parent theme settings
 */
function theme_universe_child_get_parent_settings()
{
    global $CFG;

    $settings = [];
    $parent_settings_dir = $CFG->dirroot . '/theme/universe/settings/';

    if (is_dir($parent_settings_dir)) {
        $files = scandir($parent_settings_dir);
        foreach ($files as $file) {
            if (pathinfo($file, PATHINFO_EXTENSION) === 'php') {
                $settings[] = $file;
            }
        }
    }

    return $settings;
}

/**
 * Apply parent theme settings to child theme
 * @param array $settings Array of settings to apply
 */
function theme_universe_child_apply_parent_settings($settings)
{
    global $CFG;

    foreach ($settings as $setting) {
        $parent_setting = $CFG->dirroot . '/theme/universe/settings/' . $setting;
        if (file_exists($parent_setting)) {
            require_once($parent_setting);
        }
    }
}
