<?php

namespace theme_universe_child\output;

defined('MOODLE_INTERNAL') || die();

use renderable;
use templatable;

class custom_drawer implements renderable, templatable
{

    /**
     * 
     * @var \stdClass
     */
    public $data;


    public function __construct($prevlink, $nextlink, $activitylist = array(), $currentmod, $isMobile = true, $isACoursePage = true,  $summary = '', $progreso = 0)
    {
        $this->data = new \stdClass();
        $this->data->prevlink = $prevlink;
        $this->data->nextlink = $nextlink;
        $this->data->activitylist = $activitylist;
        $this->data->currentmod = $currentmod;
        $this->data->isMobile = $isMobile;
        $this->data->isACoursePage = $isACoursePage;
        $this->data->summary = $summary;
        $this->data->progreso = $progreso;
    }

    /**
     * Export this data so it can be used as the context for a mustache template.
     *
     * @param \renderer_base $output Renderer base.
     * @return \stdClass
     */
    public function export_for_template(\renderer_base $output)
    {
        return $output->render_from_template("theme_universe_child/custom_drawer", $this->data);
    }
}
