<?php

function ll_get_username_available($first_name, $last_name)
{
    global $DB;
    $username = strtolower(trim($first_name . '-' . $last_name));
    $username = str_replace(' ', '-', $username);
    if(strlen($username) > 95) {
        $username = substr($username, 0, 95);
    }
    
    $username_search = $username;

    $i = 0; 
    do {
        if($i) {
            $i++;
            $username_search = $username .$i;
        } else {
            $username_search = $username ;
        }
        
        
        $user = $DB->get_record('user', ['username' => $username_search]);
        
    } while($user);
    
    return $username_search;
    
    
    
    
    
}

/**
 * 
 * @param string $email
 * @return mixed|stdClass|false
 */
function ll_get_user_by_email($email) 
{
    global $DB;
    
    return $DB->get_record('user', ['email' => $email]);
}

/**
 * 
 * @param stdClass $user
 * @return mixed|stdClass|false
 */
function ll_update_user($user) {
    global $DB;
    
    user_update_user($user, false);
    return $DB->get_record('user', ['id' => $user->id]);
}

/**
 * 
 * @param string $username
 * @param string $email
 * @param string $firstname
 * @param string $lastname
 * @return mixed|stdClass|false
 */
function ll_create_user($username, $email, $firstname, $lastname) 
{
    global $DB;
    
    $user = new \stdClass();
    $user->auth = 'manual';
    $user->mnethostid = 1;
    $user->confirmed = 1;
    $user->username = $username;
    $user->email = $email;
    $user->firstname = $firstname;
    $user->lastname = $lastname;
    $user->lang = 'es';
    
    $userid = $DB->insert_record('user', $user);

   // $userid = user_create_user($user, false, false);
    if($userid) {
        return $DB->get_record('user', ['id' => $userid]);
    }
}



