<?php
//namespace Cesa;
require_once(__DIR__ . '/../config.php');
require_once($CFG->libdir . '/navigationlib.php');
require_once($CFG->libdir . '/blocklib.php');

use \require_login_exception;
use \core_user;
use \moodle_exception;
use \context_user;

/**
 *
 * Cesa 
 *
 */

class Cesa
{

    public $user;
    public $title;
    public $blocks;
    public $userID;
    public $currentUser;
    public $blockManager;
    public $blockExists;
    public $blockNames;
    public $regionName;

    public function __construct($title, $blockNames, $regionName)
    {
        global $USER, $PAGE, $SITE;
        require_login(null, false);

        if (isguestuser()) {
            throw new require_login_exception('Guests are not allowed here.');
        }

        $this->userID = optional_param('userid', $USER->id, PARAM_INT);
        $this->currentUser = $this->userID == $USER->id;
        $this->user = core_user::get_user($this->userID);
        $this->title = get_string($title);
        $this->blockManager = $PAGE->blocks;
        $this->regionName = $regionName;
        $this->blockNames = is_array($blockNames) ? $blockNames : [$blockNames];
        $this->blockExists = true;

        if (!$this->user || !core_user::is_real_user($this->userID)) {
            throw new moodle_exception('invaliduser', 'error');
        }

        $PAGE->set_context(context_user::instance($this->userID));
        $PAGE->set_pagelayout('mydashboard');
        $PAGE->set_title("{$SITE->shortname}: " . $this->title);
    }

    public function addRegion($regionName)
    {

        if (!in_array($this->regionName, $this->blockManager->get_regions())) {
            $this->blockManager->add_region($this->regionName);
        }
    }

    public function validateIfExistBlocks($regionName)
    {
        $this->blockExists = true;
        $this->blocks = $this->blockManager->get_blocks_for_region($this->regionName);
        foreach ($this->blockNames as $blockName) {
            $blockFound = false;
            foreach ($this->blocks as $block) {
                $blockclass = get_class($block);
                if ($blockclass == 'block_' . $blockName) {
                    $blockFound = true;
                    break;
                }
            }
            if (!$blockFound) {
                $this->blockExists = false;
                break; // Si un bloque no existe, no es necesario seguir buscando
            }
        }
        return $this->blockExists;
    }

    public function addBlocksIfNotExist($page = 'courses')
    {
        if (!$this->blockExists) {
            foreach ($this->blockNames as $blockName) {
                $this->blockManager->add_block($blockName, $this->regionName, 1, true);
            }
        }
    }
}
