<?php

use core_completion\progress;


class block_foros_listado_renderer extends plugin_renderer_base
{

    public function procesar($instance_id)
    {

        global $USER, $CFG, $DB, $PAGE, $OUTPUT;

        $userid = $USER->id;

        require_once $CFG->libdir . '/completionlib.php';
        require_once $CFG->dirroot . '/completion/classes/progress.php';
        require_once $CFG->dirroot  . '/course/classes/category.php';
        require_once($CFG->dirroot . '/mod/forum/externallib.php');
        //require_once $CFG->libdir . '/coursecatlib.php';
        $url_noimage =  $CFG->wwwroot . '/theme/' . $PAGE->theme->name . '/pix/coursenoimage.jpg';



        $data = [
            'courses' => []
        ];

        $cids = [];
        $mycourses  = enrol_get_users_courses($USER->id);
        foreach ($mycourses as $key => $val) {
            $cids[] = $val->id;
        }

        //print_r($mycourses); exit;
        //$forums = get_all_instances_in_courses('forum', $cids);
        //print_r($forums);
        //exit;

        if (!empty($cids)) {


            $forums =  $DB->get_records_sql("SELECT cm.id AS coursemodule, m.*, cw.section, cm.visible AS visible,
                                                 cm.groupmode, cm.groupingid
                                            FROM {course_modules} cm, {course_sections} cw, {modules} md,
                                                 {forum} m
                                           WHERE cm.course IN (" . implode(',', $cids) . ") AND
                                                 cm.instance = m.id AND
                                                 cm.section = cw.id AND
                                                 md.name = 'forum' AND
                                                 m.name <> 'Avisos' AND
                                                 md.id = cm.module");


            $users = [];
            foreach ($mycourses as $key => $val) {


                $course = get_course($val->id);
                if ($course instanceof stdClass) {
                    $courseInList = new core_course_list_element($course);
                }
                $image = $url_noimage;
                foreach ($courseInList->get_course_overviewfiles() as $file) {
                    $isimage = $file->is_valid_image();
                    $image = file_encode_url("{$CFG->wwwroot}/pluginfile.php", '/' . $file->get_contextid() . '/' . $file->get_component() . '/' . $file->get_filearea() . $file->get_filepath() . $file->get_filename(), !$isimage);
                    if (!$isimage) {
                        $image = $url_noimage;
                    }
                }

                foreach ($forums as $forum) {
                    if ($course->id != $forum->course) {
                        continue;
                    }

                    $context = context_course::instance($course->id);
                    $roles = get_user_roles($context, $USER->id, true);

                    $validar_forum_visible = true;
                    foreach ($roles as $role) {
                        if ($role->shortname != 'student') {
                            $validar_forum_visible  = false;
                        }
                    }

                    if ($validar_forum_visible &&  !$forum->visible) {
                        continue;
                    }


                    $discussion_ids = [];
                    $discussions = $DB->get_records('forum_discussions', ['forum' => $forum->id]);
                    foreach ($discussions as $discussion) {
                        array_push($discussion_ids, $discussion->id);
                    }


                    $total_posts = 0;
                    $total_discussions = count($discussion_ids);
                    $user_first_post = '';
                    $user_last_post = '';
                    $date_first_post = '';
                    $date_last_post = '';


                    if ($discussion_ids) {

                        $sql = 'SELECT *  FROM {forum_posts} WHERE discussion IN (' . implode(',', $discussion_ids) . ') ORDER BY id ASC LIMIT 1 ';
                        $post = $DB->get_record_sql($sql);
                        if ($post) {
                            $date_first_post = userdate($post->created, get_string('strftimedatetimeshort', 'langconfig'));

                            $userpost = $DB->get_record('user', ['id' => $post->userid]);
                            if ($userpost) {
                                $user_first_post = trim(trim($userpost->firstname) . ' ' . trim($userpost->lastname));
                            }
                        }


                        $sql = 'SELECT * FROM {forum_posts} WHERE discussion IN (' . implode(',', $discussion_ids) . ') ORDER BY id DESC LIMIT 1 ';
                        $post = $DB->get_record_sql($sql);
                        if ($post) {
                            $date_last_post = userdate($post->created, get_string('strftimedatetimeshort', 'langconfig'));

                            $userpost = $DB->get_record('user', ['id' => $post->userid]);
                            if ($userpost) {
                                $user_last_post = trim(trim($userpost->firstname) . ' ' . trim($userpost->lastname));
                            }
                        }

                        $sql = 'SELECT COUNT(*) AS total  FROM {forum_posts} WHERE discussion IN (' . implode(',', $discussion_ids) . ') ';
                        $record = $DB->get_record_sql($sql);
                        $total_posts = $record->total;
                    }

                    $data['courses'][] = [

                        'courseimage' => $image,
                        'fullname' => $course->fullname,
                        'fullnamedisplay' => get_course_display_name_for_list($course),
                        'id' => $course->id,
                        'shortname' => $course->shortname,
                        'viewurl' => $CFG->wwwroot . '/course/view.php?id=' . $course->id,
                        'visible' => true,
                        'forumurl' =>  $CFG->wwwroot . '/mod/forum/view.php?id=' . $forum->coursemodule, //id,
                        'forumname' => $forum->name,
                        'forumintro' => $forum->intro,
                        'totalposts' => $total_posts,
                        'totaldiscussions' => $total_discussions,
                        'userfirstpost' => $user_first_post,
                        'userlastpost' => $user_last_post,
                        'datefirstpost' => $date_first_post,
                        'datelastpost' => $date_last_post,
                    ];
                }
            }
        }


        return $this->render_from_template('block_foros_listado/full', $data);
    }
}
