<?php

class block_cursosrecientes_renderer extends plugin_renderer_base {

    public function procesar($instance_id) {
        
        global $USER, $DB, $CFG, $PAGE;
        require_once $CFG->libdir . '/coursecatlib.php';
        
        $userid = $USER->id;
        $url_noimage =  $CFG->wwwroot . '/theme/' . $PAGE->theme->name . '/pix/coursenoimage.jpg';
	$type = isset($_GET['type']) ? filter_var($_GET['type'], FILTER_SANITIZE_STRING) : '';
	if($type != 'grid' && $type != 'listing') {
		$type = 'grid';
	}

	$search =  isset($_GET['search']) ? filter_var($_GET['search'], FILTER_SANITIZE_STRING) : '';

        $data = [
            'user_id' => $userid,
            'instance_id' => $instance_id,
            'courses' => [],
	    'grid' => $type == 'grid' ? true : false,
	    'listing' =>  $type == 'listing' ? true : false   	   
        ];


        
        $courselist = array();
        
        
        $mycourses = enrol_get_users_courses($userid);
	$courselist = array();
        foreach ($mycourses as $key => $val) {
		if($search) {
			if(stripos($val->fullname, $search) === false) {
				continue;
			}
		}

            $courselist[] = $val->id;
        }
        

	/*        
        $paramsql = array('userid' => $userid);
        $sql = "SELECT DISTINCT rai.courseid, rai.*
                  FROM {block_recentlyaccesseditems} rai
                  JOIN {course} c ON c.id = rai.courseid
                 WHERE userid = :userid
                 ORDER BY rai.timeaccess DESC";
        
	
        $records = $DB->get_records_sql($sql, $paramsql);


        foreach ($records as $record) {
            $courselist[] = $record->courseid;
        }*/

        for ($x = 1; $x <= sizeof($courselist); $x++) {
            $course = get_course($courselist[$x - 1]);

            if ($course instanceof stdClass) {
               
                $courseInList = new course_in_list($course);
            }
            $image = $url_noimage;
            foreach ($courseInList->get_course_overviewfiles() as $file) 
            {
                $isimage = $file->is_valid_image();
                $image = file_encode_url("{$CFG->wwwroot}/pluginfile.php", '/' . $file->get_contextid() . '/' . $file->get_component() . '/' . $file->get_filearea() . $file->get_filepath() . $file->get_filename(), !$isimage);
                if (!$isimage) {
                    $image = $url_noimage;
                }
            }
            
            $lastaccess = $DB->get_field('report_training_lastaccess', 'timeaccess', array('courseid' => $course->id, 'userid' => $userid));
            
            $category = $DB->get_record('course_categories',array('id'=>$course->category));

            
            $data['courses'][] = [
                
                'coursecategory' => $category->name,
                'courseimage' => $image,
                'enddate' => $course->enddate,
                'fullname' => $course->fullname,
                'fullnamedisplay' => get_course_display_name_for_list($course),
                'hasprogress' => true, 
                'hidden' => false,
                'id' => $course->id,
                'idnumber' => $course->idnumber,
                'isfavourite' => false,
                'progress' => 0,
                'shortname' => $course->shortname,
                'showshortname' => false,
                'startdate' => $course->startdate,
                'summary' => $course->summary,
                'summaryformat' => $course->summaryformat,
                'timeaccess' => $lastaccess,
                'viewurl' => $CFG->wwwroot . '/course/view.php?id=' . $course->id,
                'visible' => true
            ];
            
          
            
        }
        return $this->render_from_template('block_cursosrecientes/full', $data);
    }

    

}
