<?php
class block_cursos_recientes_ajax_renderer extends plugin_renderer_base
{

    public function procesar()
    {

        global $USER, $DB, $CFG;
        require_once $CFG->dirroot . "/blocks/course_list/block_course_list.php";

        $userid = $USER->id;

        $mycourses = enrol_get_users_courses($userid);

        $category_ids = [];
        $categories = [];
        foreach ($mycourses as $course) {

            if (!$course->visible) {
                continue;
            }

            /*
             stdClass Object ( [id] => 61 [category] => 13 [sortorder] => 20001 [shortname] => MAS - Diseño de landing pages [fullname] => MAS - Diseño de landing pages [idnumber] => [startdate] => 1645324020 [visible] => 1 [defaultgroupingid] => 0 [groupmode] => 0 [groupmodeforce] => 0 [ctxid] => 1606 [ctxpath] => /1/1005/3521/1606 [ctxdepth] => 4 [ctxlevel] => 50 [ctxinstance] => 61 [ctxlocked] => 0 )
             */

            if (!in_array($course->category, $category_ids)) {
                $category = $DB->get_record('course_categories', array('id' => $course->category, 'visible' => 1));
                if ($category) {



                    array_push($category_ids, $course->category);
                    array_push($categories, [
                        'id' => $category->id,
                        'name' => trim($category->name),
                    ]);
                }
            }
        }


        usort($categories, function ($a, $b) {
            return $a['name'] <=> $b['name']; //  strnatcmp($a['name'],$b['name']); // or other function/code
        });


        $data = [
            'categories' => $categories
        ];

        return $this->render_from_template('block_cursos_recientes_ajax/form', $data);
    }
}
