require(["jquery", "core/ajax"], function ($, ajax) {
  $(document).ready(function () {
    $.fn.reloadBlockCursosRecientesAjax = function () {
      $("#list-block-cursos-recientes-ajax").empty();
      ajax
        .call([
          {
            methodname: "block_cursos_recientes_ajax_list",
            args: {
              category_id: $(
                "#form-block-cursos-recientes-ajax #category_id"
              ).val(),
              search_text: $(
                "#form-block-cursos-recientes-ajax #search_text"
              ).val(),
            },
          },
        ])[0]
        .done(function (response) {
          var json = JSON.parse(response);
          console.log(json);

          if (json.success) {
            $("#list-block-cursos-recientes-ajax").html(json.cards);
          }
          return;
        })
        .fail(function (err) {
          console.log(err);
          return;
        });
    };

    $("#form-block-cursos-recientes-ajax").on("submit", function (e) {
      e.preventDefault();
      $.fn.reloadBlockCursosRecientesAjax();
      return false;
    });

    $(
      "#form-block-cursos-recientes-ajax #category_id, #form-block-cursos-recientes-ajax #search_text"
    ).change(function (e) {
      e.preventDefault();

      $.fn.reloadBlockCursosRecientesAjax();
    });

    $("span.course-badge").click(function (e) {
      e.preventDefault();

      $("#form-block-cursos-recientes-ajax #category_id").val(
        $(this).data("id")
      );
      $.fn.reloadBlockCursosRecientesAjax();
    });

    $.fn.reloadBlockCursosRecientesAjax();
  });
});
