<?php
defined('MOODLE_INTERNAL') || die();

use core_completion\progress;

global $CFG;
require_once $CFG->libdir  . '/externallib.php';
require_once $CFG->dirroot . '/course/classes/category.php';
require_once $CFG->dirroot . '/blocks/moodleblock.class.php';
require_once $CFG->dirroot . '/blocks/course_list/block_course_list.php';

class block_cursos_recientes_ajax_external extends \external_api
{
    public static function get_listado_de_cursos_recientes_parameters()
    {
        return new \external_function_parameters([
            'category_id' => new \external_value(PARAM_INT, 'Categoría de los Cursos', VALUE_DEFAULT, 0),
            'search_text' => new \external_value(PARAM_ALPHANUM, 'Palabra de busqueda', VALUE_DEFAULT, ' '),
        ]);
    }

    public static function get_listado_de_cursos_recientes($category_id, $search_text)
    {

        /*
        [
        'category_id' => $category_id,
        'search_text' => $search_text,
        ] = self::validate_parameters(self::execute_parameters(), [
            'category_id' => $category_id,
            'search_text' => $search_text
        ]);
        */

        global $USER, $DB, $CFG, $OUTPUT, $PAGE;


        $userid = $USER->id;
        $url_noimage =  $CFG->wwwroot . '/theme/' . $PAGE->theme->name . '/pix/coursenoimage.jpg';

        $courses = [];
        $courselist = array();


        $mycourses = enrol_get_users_courses($userid);

        $courselist = array();
        foreach ($mycourses as $course) {
            if (!$course->visible) {
                continue;
            }


            if ($search_text) {
                if (stripos($course->fullname, $search_text) === false) {
                    continue;
                }
            }

            if ($category_id) {
                if ($category_id != $course->category) {
                    continue;
                }
            }

            $category = $DB->get_record('course_categories', array('id' => $course->category, 'visible' => 1));
            if (!$category) {
                continue;
            }


            if ($course instanceof stdClass) {
                $courseInList = new core_course_list_element($course);
            }
            $image = $url_noimage;
            foreach ($courseInList->get_course_overviewfiles() as $file) {
                $isimage = $file->is_valid_image();
                $image = file_encode_url("{$CFG->wwwroot}/pluginfile.php", '/' . $file->get_contextid() . '/' . $file->get_component() . '/' . $file->get_filearea() . $file->get_filepath() . $file->get_filename(), !$isimage);
                if (!$isimage) {
                    $image = $url_noimage;
                }
            }

            $lastaccess = null;
            $sql = "select timecreated  from {logstore_standard_log} where courseid  = :courseid and userid  = :userid " .
                "  and eventname  = '\\\\core\\\\event\\\\course_viewed' order by id desc limit 1 ";

            $timecreated = $DB->get_field_sql($sql,  array('courseid' => $course->id, 'userid' => $userid));
            if ($timecreated) {

                $lastaccess = date('d/m/Y h:i a', $timecreated);
            }



            $miProgreso = number_format(progress::get_course_progress_percentage($course), 2); // Progreso por curso


            $first_section = 0;
            $sections = $DB->get_records('course_sections', ['course' => $course->id], 'section ASC', 'id,name,section,sequence,visible');

            foreach ($sections as $section) {
                if (!empty($section->section)) {
                    $first_section = $section->id;
                    break;
                }
            }
            $course_context = context_course::instance($course->id);
            $roles = get_user_roles($course_context, $USER->id, true);

            $completion_edit_curso = false;
            foreach ($roles as $role) {
                if ($role->shortname == 'companydepartmentmanager' || $role->shortname == 'companycoursenoneditor') {
                    $completion_edit_curso  = true;
                    break;
                }
            }

            if (has_capability('moodle/course:manageactivities', $course_context, $USER->id) || has_capability('moodle/course:viewhiddenactivities', $course_context, $USER->id) || $completion_edit_curso) {
                $editurl = $CFG->wwwroot . '/course/view.php?id=' . $course->id . '&notifyeditingon=1';

                //$editurl = $CFG->wwwroot . '/course/edit.php?id=' . $course->id;
            } else {
                $editurl = '';
            }



            $modules = get_fast_modinfo($course->id)->get_cms();



            $linkurl = '';
            foreach ($modules as $module) {




                //print "!".$module->uservisible ."||". $module->is_stealth() ."||". $module->url ."||". $module->section."<br>";
                if (!$module->uservisible || $module->is_stealth() || empty($module->url) || empty($module->section)) {
                    continue;
                }

                if ($module->section == $first_section || $completion_edit_curso) {





                    $linkurl =  new moodle_url($module->url, array('forceview' => 1));
                    //print_r($linkurl);
                    //var_dump($linkurl);
                    break;
                }
            }
            /*
            if( $completion_edit_curso){
                $linkurl = $CFG->wwwroot . '/course/view.php?id=' . $course->id;
            }*/

            $summary = trim(strip_tags($course->summary));

            if (empty($summary)) {
                $summary = `<p></p>`;
            } else if (strlen($summary) > 80) {

                $summary =  substr($summary, 0, 80) . '...';
            }

            $courses[] = [

                'coursecategory' => $category->name,
                'courseimage' => $image,
                'enddate' => $course->enddate,
                'fullname' => $course->fullname,
                'fullnamedisplay' => get_course_display_name_for_list($course),
                'hasprogress' => true,
                'hidden' => false,
                'id' => $course->id,
                'idnumber' => $course->idnumber,
                'isfavourite' => false,
                'progress' => $miProgreso,
                'shortname' => $course->shortname,
                'showshortname' => false,
                'startdate' => $course->startdate,
                'summary' =>  $summary,
                'summaryformat' => $course->summaryformat,
                'timeaccess' => $lastaccess,
                'viewurl' => $linkurl,
                'editurl' => $editurl,
                'visible' => true,

            ];
        }

        $data = [
            'courses' => $courses
        ];

        $cards = $OUTPUT->render_from_template('block_cursos_recientes_ajax/cards', $data);


        return json_encode(['success' => true, 'search_text' => $search_text, 'category_id' => $category_id,  'cards' => $cards]);
    }

    public static function get_listado_de_cursos_recientes_returns()
    {
        return new \external_value(PARAM_RAW, 'The updated JSON output');
    }
}
