<?php
class block_cursos_catalogo_ajax_renderer extends plugin_renderer_base
{

    public function procesar()
    {

        global $USER, $DB, $CFG;
        require_once $CFG->dirroot . "/blocks/course_list/block_course_list.php";

        $is_admin = false;
        $admins = get_admins();
        foreach ($admins as $admin) {
            if ($USER->id == $admin->id) {
                $is_admin = true;
                break;
            }
        }


        $category_ids = [];


        if ($is_admin) {
            $mycourses = get_courses();
            foreach ($mycourses as $course) {
                if (!$course->visible) {
                    continue;
                }


                if (!in_array($course->category, $category_ids)) {
                    array_push($category_ids, $course->category);
                }
            }
        } else {
            $mycourses  = enrol_get_users_courses($USER->id);
            foreach ($mycourses as $course) {
                if (!$course->visible) {
                    continue;
                }

                if (!in_array($course->category, $category_ids)) {
                    array_push($category_ids, $course->category);
                }
            }


            $courses_with_autoenrol  = $DB->get_records('enrol', ['enrol' => 'self']);
            foreach ($courses_with_autoenrol as $course_with_autoenrol) {
                $course = get_course($course_with_autoenrol->courseid);
                if (!$course->visible) {
                    continue;
                }

                if (!in_array($course->category, $category_ids)) {
                    array_push($category_ids, $course->category);
                }
            }
        }

        /*
             public function get_records($table, array $conditions=null, $sort='', $fields='*', $limitfrom=0, $limitnum=0) {
        list($select, $params) = $this->where_clause($table, $conditions);
        return $this->get_records_select($table, $select, $params, $sort, $fields, $limitfrom, $limitnum);
    }
         */


        $categories = [];
        $recordsLevel0 = $DB->get_records('course_categories', ['visible' => 1, 'parent' => 0], 'sortorder, name');
        foreach ($recordsLevel0 as $recordLevel0) {

            $categoryLevel0 = [
                'id' => $recordLevel0->id,
                'name' => $recordLevel0->name,
                'coursecount' => $recordLevel0->coursecount,
                'childsLevel0' => [],

            ];

            $recordsLevel1 = $DB->get_records('course_categories', ['visible' => 1, 'parent' => $recordLevel0->id], 'sortorder, name');
            foreach ($recordsLevel1 as $recordLevel1) {
                $categoryLevel1 = [
                    'id' => $recordLevel1->id,
                    'name' => $recordLevel1->name,
                    'coursecount' => $recordLevel1->coursecount,
                    'childsLevel1' => [],
                ];

                $recordsLevel2 = $DB->get_records('course_categories', ['visible' => 1, 'parent' => $recordLevel1->id], 'sortorder, name');
                foreach ($recordsLevel2 as $recordLevel2) {
                    $categoryLevel2 = [
                        'id' => $recordLevel2->id,
                        'name' => $recordLevel2->name,
                        'coursecount' => $recordLevel2->coursecount,
                        'childsLevel2' => [],
                    ];



                    $recordsLevel3 = $DB->get_records('course_categories', ['visible' => 2, 'parent' => $recordLevel2->id], 'sortorder, name');
                    foreach ($recordsLevel3 as $recordLevel3) {
                        $categoryLevel3 = [
                            'id' => $recordLevel3->id,
                            'name' => $recordLevel3->name,
                        ];
                        array_push($categoryLevel2['childsLevel2'], $categoryLevel3);
                    }

                    if (count($categoryLevel1['childsLevel2']) > 0 || $categoryLevel2['coursecount'] > 0) {
                        array_push($categoryLevel1['childsLevel1'], $categoryLevel2);
                    }
                }

                if (count($categoryLevel1['childsLevel1']) > 0 || $categoryLevel1['coursecount'] > 0) {
                    array_push($categoryLevel0['childsLevel0'], $categoryLevel1);
                }
            }

            if (count($categoryLevel0['childsLevel0']) > 0 || $categoryLevel0['coursecount'] > 0) {
                array_push($categories, $categoryLevel0);
            }
        }

        $data = [
            'categories' => $categories
        ];

        return $this->render_from_template('block_cursos_catalogo_ajax/form', $data);
    }
}
